/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.choppersdelight.item.custom;

import com.phantomwing.choppersdelight.component.DecoratedCuttingBoardData;
import com.phantomwing.choppersdelight.component.ModDataComponents;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.item.FuelBlockItem;
import vectorwing.farmersdelight.common.registry.ModItems;

public class DecoratedCuttingBoardItem
extends FuelBlockItem {
    public DecoratedCuttingBoardItem(Block block, Item.Properties properties, int burnTime) {
        super(block, properties, burnTime);
    }

    public static ItemStack getCuttingBoardStack(ItemStack stack) {
        DecoratedCuttingBoardData data;
        if (stack.getItem() instanceof DecoratedCuttingBoardItem && (data = (DecoratedCuttingBoardData)stack.get((DataComponentType)ModDataComponents.DECORATED_CUTTING_BOARD_DATA.get())) != null) {
            return data.cuttingBoard().copy();
        }
        return new ItemStack((ItemLike)ModItems.CUTTING_BOARD.get());
    }

    public static ItemStack getBannerStack(ItemStack stack) {
        DecoratedCuttingBoardData data;
        if (stack.getItem() instanceof DecoratedCuttingBoardItem && (data = (DecoratedCuttingBoardData)stack.get((DataComponentType)ModDataComponents.DECORATED_CUTTING_BOARD_DATA.get())) != null) {
            return data.banner().copy();
        }
        return new ItemStack((ItemLike)Items.WHITE_BANNER);
    }

    @NotNull
    public String getDescriptionId(@NotNull ItemStack stack) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)DecoratedCuttingBoardItem.getCuttingBoardStack(stack).getItem());
        return "block." + id.getNamespace() + "." + id.getPath();
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        ItemStack banner = DecoratedCuttingBoardItem.getBannerStack(stack);
        if (!banner.isEmpty()) {
            Component customName = (Component)banner.get(DataComponents.CUSTOM_NAME);
            if (customName != null) {
                tooltipComponents.add((Component)customName.copy().withStyle(ChatFormatting.GRAY));
            } else {
                Component itemName = (Component)banner.get(DataComponents.ITEM_NAME);
                if (itemName != null) {
                    tooltipComponents.add((Component)itemName.copy().withStyle(ChatFormatting.GRAY));
                } else {
                    tooltipComponents.add((Component)Component.translatable((String)banner.getDescriptionId()).withStyle(ChatFormatting.GRAY));
                    BannerItem.appendHoverTextFromBannerBlockEntityTag((ItemStack)banner, tooltipComponents);
                }
            }
        }
    }
}

