/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.choppersdelight.recipe.custom;

import com.phantomwing.choppersdelight.component.DecoratedCuttingBoardData;
import com.phantomwing.choppersdelight.component.ModDataComponents;
import com.phantomwing.choppersdelight.item.ModItems;
import com.phantomwing.choppersdelight.recipe.ModRecipes;
import com.phantomwing.choppersdelight.tags.ModTags;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AddCuttingBoardPatternRecipe
extends CustomRecipe {
    public AddCuttingBoardPatternRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@Nonnull CraftingInput inv, @Nonnull Level level) {
        ItemStack bannerStack = ItemStack.EMPTY;
        ItemStack cuttingBoardStack = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof BannerItem) {
                if (!bannerStack.isEmpty()) {
                    return false;
                }
                bannerStack = stack;
                continue;
            }
            if (stack.is(ModTags.Items.CUTTING_BOARDS)) {
                if (!cuttingBoardStack.isEmpty()) {
                    return false;
                }
                cuttingBoardStack = stack;
                continue;
            }
            return false;
        }
        return !bannerStack.isEmpty() && !cuttingBoardStack.isEmpty();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInput inv, @Nonnull HolderLookup.Provider provider) {
        ItemStack bannerStack = ItemStack.EMPTY;
        ItemStack cuttingBoardStack = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof BannerItem) {
                bannerStack = stack.copy();
                bannerStack.setCount(1);
                continue;
            }
            if (!stack.is(ModTags.Items.CUTTING_BOARDS)) continue;
            cuttingBoardStack = stack.copy();
        }
        if (cuttingBoardStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.DECORATED_CUTTING_BOARD.get());
        stack.set((DataComponentType)ModDataComponents.DECORATED_CUTTING_BOARD_DATA.get(), (Object)new DecoratedCuttingBoardData(cuttingBoardStack.copy(), bannerStack.copy()));
        return stack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.ADD_PATTERN_RECIPE.get();
    }
}

