/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.choppersdelight.recipe.custom;

import com.phantomwing.choppersdelight.item.custom.DecoratedCuttingBoardItem;
import com.phantomwing.choppersdelight.recipe.ModRecipes;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class RemoveCuttingBoardPatternRecipe
extends CustomRecipe {
    public RemoveCuttingBoardPatternRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@Nonnull CraftingInput inv, @Nonnull Level level) {
        ItemStack itemstack = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (!itemstack.isEmpty() || !(stack.getItem() instanceof DecoratedCuttingBoardItem)) {
                return false;
            }
            itemstack = stack.copy();
        }
        return !itemstack.isEmpty();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInput inv, @Nonnull HolderLookup.Provider provider) {
        ItemStack itemstack = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof DecoratedCuttingBoardItem)) continue;
            itemstack = stack.copy();
            break;
        }
        if (itemstack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return DecoratedCuttingBoardItem.getBannerStack(itemstack);
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList nonnulllist = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = inv.getItem(i);
            if (item.isEmpty() || !(item.getItem() instanceof DecoratedCuttingBoardItem)) continue;
            nonnulllist.set(i, (Object)DecoratedCuttingBoardItem.getCuttingBoardStack(item));
        }
        return nonnulllist;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.REMOVE_PATTERN_RECIPE.get();
    }
}

