/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.choppersdelight.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.phantomwing.choppersdelight.item.custom.DecoratedCuttingBoardItem;
import com.phantomwing.choppersdelight.utils.BannerUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.neoforged.neoforge.client.ClientHooks;
import vectorwing.farmersdelight.common.registry.ModItems;

public class DecoratedCuttingBoardItemStackRenderer
extends BlockEntityWithoutLevelRenderer {
    private final ModelPart bannerModelPart = BannerUtils.initializeBannerModelPart();

    public DecoratedCuttingBoardItemStackRenderer(BlockEntityRenderDispatcher blockEntityRenderDispatcher, EntityModelSet entityModelSet) {
        super(blockEntityRenderDispatcher, entityModelSet);
    }

    public void renderByItem(@Nonnull ItemStack stack, @Nonnull ItemDisplayContext displayContext, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        Item item;
        ItemStack cuttingBoardItem = DecoratedCuttingBoardItem.getCuttingBoardStack(stack);
        if (cuttingBoardItem.isEmpty()) {
            cuttingBoardItem = new ItemStack((ItemLike)ModItems.CUTTING_BOARD.get());
        }
        poseStack.translate(0.5, 0.5, 0.5);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        itemRenderer.renderStatic(cuttingBoardItem, displayContext, light, overlay, poseStack, buffer, null, 0);
        ItemStack bannerItemStack = DecoratedCuttingBoardItem.getBannerStack(stack);
        if (bannerItemStack.isEmpty()) {
            bannerItemStack = new ItemStack((ItemLike)Items.WHITE_BANNER);
        }
        if ((item = bannerItemStack.getItem()) instanceof BannerItem) {
            BannerItem bannerItem = (BannerItem)item;
            BakedModel model = itemRenderer.getModel(cuttingBoardItem, null, null, 0);
            ClientHooks.handleCameraTransforms((PoseStack)poseStack, (BakedModel)model, (ItemDisplayContext)displayContext, (boolean)false);
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            BannerUtils.renderBanner(poseStack, buffer, this.bannerModelPart, light, overlay, Direction.SOUTH, bannerItem.getColor(), (BannerPatternLayers)bannerItemStack.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY));
        }
    }
}

