/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.choppersdelight.ui;

import com.phantomwing.choppersdelight.Compatibility;
import com.phantomwing.choppersdelight.block.ModBlocks;
import com.phantomwing.choppersdelight.component.DecoratedCuttingBoardData;
import com.phantomwing.choppersdelight.component.ModDataComponents;
import com.phantomwing.choppersdelight.item.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModCreativeModeTab {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"choppersdelight");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MOD_TAB = CREATIVE_MODE_TABS.register("choppersdelight_tab", () -> CreativeModeTab.builder().icon(ModCreativeModeTab::getTabIcon).title((Component)Component.translatable((String)"itemGroup.choppersdelight")).displayItems(ModCreativeModeTab::displayItems).build());

    public static ItemStack getTabIcon() {
        return ModCreativeModeTab.getDecoratedCuttingBoard(ModBlocks.DARK_OAK_CUTTING_BOARD, Items.GREEN_BANNER, (ResourceKey<BannerPattern>)BannerPatterns.CREEPER, DyeColor.BLACK);
    }

    public static ItemStack getDecoratedCuttingBoard(DeferredBlock<Block> board, Item banner, ResourceKey<BannerPattern> pattern, DyeColor patternColor) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            ItemStack cuttingBoard = new ItemStack((ItemLike)board.get());
            Registry bannerPatternRegistry = level.registryAccess().registryOrThrow(Registries.BANNER_PATTERN);
            Holder.Reference patternHolder = bannerPatternRegistry.getHolderOrThrow(pattern);
            ItemStack bannerStack = new ItemStack((ItemLike)banner);
            BannerPatternLayers layers = new BannerPatternLayers.Builder().add((Holder)patternHolder, patternColor).build();
            bannerStack.set(DataComponents.BANNER_PATTERNS, (Object)layers);
            ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.DECORATED_CUTTING_BOARD.get());
            DecoratedCuttingBoardData cuttingBoardData = new DecoratedCuttingBoardData(cuttingBoard, bannerStack);
            itemStack.set((DataComponentType)ModDataComponents.DECORATED_CUTTING_BOARD_DATA.get(), (Object)cuttingBoardData);
            return itemStack;
        }
        return new ItemStack((ItemLike)ModBlocks.DECORATED_CUTTING_BOARD.get());
    }

    public static void displayItems(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        ModCreativeModeTab.displayModItems(parameters, output);
        ModCreativeModeTab.displayBiomesOPlentyItems(parameters, output);
        ModCreativeModeTab.displayBiomesWeveGoneItems(parameters, output);
        output.accept(ModCreativeModeTab.getDecoratedCuttingBoard(ModBlocks.CHERRY_CUTTING_BOARD, Items.WHITE_BANNER, (ResourceKey<BannerPattern>)BannerPatterns.FLOWER, DyeColor.PINK));
        output.accept(ModCreativeModeTab.getDecoratedCuttingBoard(ModBlocks.DARK_OAK_CUTTING_BOARD, Items.GREEN_BANNER, (ResourceKey<BannerPattern>)BannerPatterns.CREEPER, DyeColor.BLACK));
        output.accept(ModCreativeModeTab.getDecoratedCuttingBoard(ModBlocks.CRIMSON_CUTTING_BOARD, Items.BLACK_BANNER, (ResourceKey<BannerPattern>)BannerPatterns.SKULL, DyeColor.WHITE));
        output.accept(ModCreativeModeTab.getDecoratedCuttingBoard(ModBlocks.WARPED_CUTTING_BOARD, Items.BLACK_BANNER, (ResourceKey<BannerPattern>)BannerPatterns.FLOW, DyeColor.CYAN));
    }

    public static void displayModItems(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        ModItems.CREATIVE_TAB_ITEMS.forEach(item -> {
            output.accept((ItemLike)item.get());
            if (ItemStack.isSameItem((ItemStack)((Item)item.get()).getDefaultInstance(), (ItemStack)new ItemStack((ItemLike)ModItems.OAK_CUTTING_BOARD.get()))) {
                output.accept(new ItemStack((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.CUTTING_BOARD.get()));
            }
        });
    }

    public static void displayBiomesOPlentyItems(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        if (!Compatibility.IsBiomesOPlentyLoaded()) {
            return;
        }
        ModItems.BIOMES_O_PLENTY_CREATIVE_TAB_ITEMS.forEach(item -> output.accept((ItemLike)item.get()));
    }

    public static void displayBiomesWeveGoneItems(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        if (!Compatibility.IsBiomesWeveGoneLoaded()) {
            return;
        }
        ModItems.BIOMES_WEVE_GONE_CREATIVE_TAB_ITEMS.forEach(item -> output.accept((ItemLike)item.get()));
    }

    public static Holder<BannerPattern> getCreeperPattern() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        Registry registry = level.registryAccess().registryOrThrow(Registries.BANNER_PATTERN);
        return registry.getHolderOrThrow(BannerPatterns.CREEPER);
    }

    public static void register(IEventBus eventBus) {
        CREATIVE_MODE_TABS.register(eventBus);
    }
}

