/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.choppersdelight.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.phantomwing.choppersdelight.block.entity.DecoratedCuttingBoardBlockEntity;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class BannerUtils {
    public static ModelPart initializeBannerModelPart() {
        CubeListBuilder cubeListBuilder = new CubeListBuilder();
        cubeListBuilder.texOffs(0, 0);
        cubeListBuilder.addBox(-10.0f, 0.0f, -2.0f, 20.0f, 40.0f, 1.0f);
        List cuboids = cubeListBuilder.getCubes().stream().map(modelCuboidData -> modelCuboidData.bake(64, 64)).collect(Collectors.toList());
        return new ModelPart(cuboids, new HashMap());
    }

    public static void renderBanner(PoseStack poseStack, MultiBufferSource buffer, ModelPart modelPart, int light, int overlay, Direction direction, DecoratedCuttingBoardBlockEntity blockEntity) {
        Item item;
        ItemStack banner = blockEntity.getBanner();
        if (!banner.isEmpty() && (item = banner.getItem()) instanceof BannerItem) {
            BannerItem bannerItem = (BannerItem)item;
            DyeColor dyeColor = bannerItem.getColor();
            BannerPatternLayers patternLayers = (BannerPatternLayers)banner.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
            BannerUtils.renderBanner(poseStack, buffer, modelPart, light, overlay, direction, dyeColor, patternLayers);
        }
    }

    public static void renderBanner(PoseStack poseStack, MultiBufferSource buffer, ModelPart modelPart, int light, int overlay, Direction direction, DyeColor dyeColor, BannerPatternLayers patternLayers) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(direction.toYRot()));
        poseStack.translate(-0.5, -0.5, -0.5);
        poseStack.translate(0.28125, 0.9375, 1.0625);
        poseStack.translate(0.0, 1.0E-4, 0.01);
        poseStack.scale(-0.351f, -0.351f, 1.1f);
        BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)buffer, (int)light, (int)overlay, (ModelPart)modelPart, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)dyeColor, (BannerPatternLayers)patternLayers);
        poseStack.popPose();
    }
}

