/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.mixin;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseMixin {
    @Shadow
    protected abstract void doPlayerRide(Player var1);

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void mobInteract(Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        AbstractHorse horse = (AbstractHorse)this;
        if (!horse.isTamed() && player.isCreative()) {
            horse.tameWithName(player);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
        if (horse.isVehicle()) {
            this.doPlayerRide(player);
            player.startRiding((Entity)horse, true);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }
}

