/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void travel(Vec3 vec3, CallbackInfo ci) {
        AbstractHorse horse;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof AbstractHorse && !(horse = (AbstractHorse)livingEntityMixin).isVehicle() && horse.isSaddled()) {
            boolean falling;
            double gravity = horse.getGravity();
            boolean bl = falling = horse.getDeltaMovement().y <= 0.0;
            if (falling && horse.hasEffect(MobEffects.SLOW_FALLING)) {
                gravity = Math.min(gravity, 0.01);
            }
            BlockPos blockPos = horse.getBlockPosBelowThatAffectsMyMovement();
            float friction = horse.level().getBlockState(blockPos).getBlock().getFriction();
            Vec3 vec = horse.handleRelativeFrictionAndCalculateMovement(Vec3.ZERO, friction);
            double y = vec.y;
            y = horse.hasEffect(MobEffects.LEVITATION) ? (y += (0.05 * (double)(horse.getEffect(MobEffects.LEVITATION).getAmplifier() + 1) - vec.y) * 0.2) : (y -= gravity);
            if (horse.shouldDiscardFriction()) {
                horse.setDeltaMovement(0.0, y, 0.0);
            } else {
                horse.setDeltaMovement(0.0, y * (double)0.98f, 0.0);
            }
            horse.calculateEntityAnimation(false);
            ci.cancel();
        }
    }
}

