/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.moobloom;

import com.belgie.moobloom.PlaceFlowerGoal;
import com.belgie.moobloom.Registry;
import com.belgie.moobloom.Tags;
import com.belgie.moobloom.variant.MoobloomVariant;
import com.belgie.moobloom.variant.MoobloomVariants;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.AbstractCow;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraftforge.event.ForgeEventFactory;

public class MoobloomEntity
extends AbstractCow
implements Shearable {
    private static final EntityDataAccessor<Integer> COOLDOWN = SynchedEntityData.defineId(MoobloomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Holder<MoobloomVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(MoobloomEntity.class, Registry.MOOBLOOM_VARIANT.get());

    public MoobloomEntity(EntityType<? extends MoobloomEntity> p_28914_, Level p_28915_) {
        super(p_28914_, p_28915_);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, p_401437_ -> p_401437_.is(ItemTags.COW_FOOD), false));
        this.goalSelector.addGoal(4, (Goal)new PlaceFlowerGoal(this));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public Holder<MoobloomVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    public void setVariant(Holder<MoobloomVariant> p_332777_) {
        this.entityData.set(DATA_VARIANT_ID, p_332777_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    public float getWalkTargetValue(BlockPos p_28933_, LevelReader p_28934_) {
        return p_28934_.getBlockState(p_28933_.below()).is(Blocks.GRASS_BLOCK) ? 10.0f : p_28934_.getPathfindingCostFromLightLevels(p_28933_);
    }

    public static boolean checkMushroomSpawnRules(EntityType<MoobloomEntity> entityType, LevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(Tags.MOOBLOOM_SPAWN_ON) && MoobloomEntity.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos);
    }

    public void tick() {
        if (this.getCooldown() != 0) {
            this.setCooldown(this.getCooldown() - 1);
        }
        super.tick();
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_401390_) {
        super.defineSynchedData(p_401390_);
        p_401390_.define(DATA_VARIANT_ID, (Object)VariantUtils.getDefaultOrAny((RegistryAccess)this.registryAccess(), MoobloomVariants.DEFAULT));
        p_401390_.define(COOLDOWN, (Object)0);
    }

    public void addAdditionalSaveData(ValueOutput p_401080_) {
        super.addAdditionalSaveData(p_401080_);
        VariantUtils.writeVariant((ValueOutput)p_401080_, this.getVariant());
        p_401080_.putInt("Cooldown", this.getCooldown());
    }

    public void readAdditionalSaveData(ValueInput p_401438_) {
        super.readAdditionalSaveData(p_401438_);
        VariantUtils.readVariant((ValueInput)p_401438_, Registry.MOOBLOOM_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
        this.setCooldown(p_401438_.getIntOr("Cooldown", 0));
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.BUCKET) && !this.isBaby()) {
            player.playSound(SoundEvents.COW_MILK, 1.0f, 1.0f);
            ItemStack itemStack2 = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)Items.MILK_BUCKET.getDefaultInstance());
            player.setItemInHand(hand, itemStack2);
            return InteractionResult.SUCCESS;
        }
        if (!player.isCreative()) {
            itemStack.shrink(1);
        } else {
            if (itemStack.is(Items.SHEARS) && this.readyForShearing()) {
                Level var10 = this.level();
                if (var10 instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)var10;
                    this.shear(serverlevel, SoundSource.PLAYERS, itemStack);
                    this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                    itemStack.hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
                }
                return InteractionResult.SUCCESS;
            }
            if (itemStack.is(Items.BONE_MEAL) && !this.isBaby() && ((MoobloomVariant)this.getVariant().value()).allowBonemeal() && this.getCooldown() == 0) {
                for (int i = 0; i < 2; ++i) {
                    this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(1.0), this.getZ(), ((MoobloomVariant)this.getVariant().value()).block().getBlock().asItem().getDefaultInstance()));
                }
                this.setCooldown(((MoobloomVariant)this.getVariant().value()).bonemealcooldown());
                this.playSound(SoundEvents.BONE_MEAL_USE, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    public MoobloomEntity getBreedOffspring(ServerLevel p_148890_, AgeableMob p_148891_) {
        MoobloomEntity cow = (MoobloomEntity)Registry.MOOBLOOM.get().create((Level)p_148890_, EntitySpawnReason.BREEDING);
        if (cow != null && p_148891_ instanceof MoobloomEntity) {
            MoobloomEntity cow1 = (MoobloomEntity)p_148891_;
            cow.setVariant(this.random.nextBoolean() ? this.getVariant() : cow1.getVariant());
        }
        return cow;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_401024_, DifficultyInstance p_401230_, EntitySpawnReason p_401413_, @Nullable SpawnGroupData p_401109_) {
        Holder registryEntry = p_401024_.getBiome(this.getOnPos());
        net.minecraft.core.Registry registry = this.registryAccess().lookupOrThrow(Registry.MOOBLOOM_VARIANT_REGISTRY_KEY);
        if (registryEntry.is(Biomes.PALE_GARDEN) && p_401024_.getLevel().isMoonVisible()) {
            this.setVariant((Holder<MoobloomVariant>)((Holder)registry.get(MoobloomVariants.EYEBLOSSOM_OPEN).orElseThrow()));
        } else if (registryEntry.is(Biomes.PALE_GARDEN) && !p_401024_.getLevel().isMoonVisible()) {
            this.setVariant((Holder<MoobloomVariant>)((Holder)registry.get(MoobloomVariants.EYEBLOSSOM_CLOSED).orElseThrow()));
        } else {
            MoobloomVariants.selectVariantToSpawn(this.random, this.registryAccess(), SpawnContext.create((ServerLevelAccessor)p_401024_, (BlockPos)this.blockPosition())).ifPresent(this::setVariant);
        }
        return super.finalizeSpawn(p_401024_, p_401230_, p_401413_, p_401109_);
    }

    private void setCooldown(int p_28929_) {
        this.entityData.set(COOLDOWN, (Object)p_28929_);
    }

    public int getCooldown() {
        return (Integer)this.entityData.get(COOLDOWN);
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> p_401147_) {
        return (T)(p_401147_ == Registry.MOOBLOOM_VARIANT_COM.get() ? MoobloomEntity.castComponentValue(p_401147_, this.getVariant()) : super.get(p_401147_));
    }

    protected void applyImplicitComponents(DataComponentGetter p_401126_) {
        this.applyImplicitComponentIfPresent(p_401126_, Registry.MOOBLOOM_VARIANT_COM.get());
        super.applyImplicitComponents(p_401126_);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> p_401334_, T p_401008_) {
        if (p_401334_ == Registry.MOOBLOOM_VARIANT_COM.get()) {
            this.setVariant((Holder<MoobloomVariant>)((Holder)MoobloomEntity.castComponentValue(Registry.MOOBLOOM_VARIANT_COM.get(), p_401008_)));
            return true;
        }
        return super.applyImplicitComponent(p_401334_, p_401008_);
    }

    public void shear(ServerLevel p_376375_, SoundSource p_28924_, ItemStack p_373092_) {
        p_376375_.playSound((Entity)((Player)null), (Entity)this, SoundEvents.MOOSHROOM_SHEAR, p_28924_, 1.0f, 1.0f);
        if (ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.COW, timer -> {})) {
            this.convertTo(EntityType.COW, ConversionParams.single((Mob)this, (boolean)false, (boolean)false), p_390217_ -> {
                ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)p_390217_);
                p_376375_.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                this.dropFromShearingLootTable(p_376375_, ((MoobloomVariant)this.getVariant().value()).shearloot(), p_373092_, (p_390218_, p_390219_) -> {
                    for (int i = 0; i < p_390219_.getCount(); ++i) {
                        ItemEntity item = this.spawnAtLocation((ServerLevel)p_390218_, p_390219_.copyWithCount(1), this.getBbHeight());
                        if (item == null) continue;
                        item.setNoPickUpDelay();
                    }
                });
            });
        }
    }

    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby();
    }
}

