/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.moobloom;

import com.belgie.moobloom.ClientInit;
import com.belgie.moobloom.Registry;
import com.belgie.moobloom.Tags;
import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DataPackRegistryEvent;
import org.slf4j.Logger;

@Mod(value="moobloom")
public class MoobloomMod {
    public static final String ID = "moobloom";
    private static final Logger LOGGER = LogUtils.getLogger();

    public MoobloomMod(FMLJavaModLoadingContext context) {
        BusGroup Bus2 = context.getModBusGroup();
        FMLCommonSetupEvent.getBus((BusGroup)Bus2).addListener(this::setup);
        DataPackRegistryEvent.NewRegistry.getBus((BusGroup)Bus2).addListener(Registry::registerDatapackRegistries);
        FMLClientSetupEvent.getBus((BusGroup)Bus2).addListener(this::setupClient);
        Registry.ITEM.register(Bus2);
        Registry.ENTITY.register(Bus2);
        Registry.SERIALIZER_DEFERRED_REGISTER.register(Bus2);
        Registry.DATA.register(Bus2);
        BuildCreativeModeTabContentsEvent.getBus((BusGroup)Bus2).addListener(this::addCreative);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Tags.Init();
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            event.accept(Registry.MOOBLOOM_SPAWN_EGG);
        }
    }

    @SubscribeEvent
    private void setup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void setupClient(FMLClientSetupEvent event) {
        ClientInit.Init();
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }
}

