/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.moobloom;

import com.belgie.moobloom.MoobloomEntity;
import com.belgie.moobloom.MoobloomLayer;
import com.belgie.moobloom.MoobloomModel;
import com.belgie.moobloom.MoobloomRenderState;
import com.belgie.moobloom.variant.MoobloomVariant;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.model.AdultAndBabyModelPair;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoobloomRenderer
extends MobRenderer<MoobloomEntity, MoobloomRenderState, MoobloomModel> {
    private final Map<MoobloomVariant.ModelType, AdultAndBabyModelPair<MoobloomModel>> models;

    public MoobloomRenderer(EntityRendererProvider.Context p_173956_) {
        super(p_173956_, (EntityModel)new MoobloomModel(p_173956_.bakeLayer(ModelLayers.COW)), 0.7f);
        this.models = MoobloomRenderer.bakeModels(p_173956_);
        this.addLayer(new MoobloomLayer((RenderLayerParent<MoobloomRenderState, MoobloomModel>)this, p_173956_.getBlockRenderDispatcher()));
    }

    private static Map<MoobloomVariant.ModelType, AdultAndBabyModelPair<MoobloomModel>> bakeModels(EntityRendererProvider.Context p_401303_) {
        return Maps.newEnumMap(Map.of(MoobloomVariant.ModelType.NORMAL, new AdultAndBabyModelPair((Model)new MoobloomModel(p_401303_.bakeLayer(ModelLayers.COW)), (Model)new MoobloomModel(p_401303_.bakeLayer(ModelLayers.COW_BABY))), MoobloomVariant.ModelType.WARM, new AdultAndBabyModelPair((Model)new MoobloomModel(p_401303_.bakeLayer(ModelLayers.WARM_COW)), (Model)new MoobloomModel(p_401303_.bakeLayer(ModelLayers.WARM_COW_BABY))), MoobloomVariant.ModelType.COLD, new AdultAndBabyModelPair((Model)new MoobloomModel(p_401303_.bakeLayer(ModelLayers.COLD_COW)), (Model)new MoobloomModel(p_401303_.bakeLayer(ModelLayers.COLD_COW_BABY)))));
    }

    public ResourceLocation getTextureLocation(MoobloomRenderState p_401372_) {
        return p_401372_.variant == null ? MissingTextureAtlasSprite.getLocation() : p_401372_.variant.modelAndTexture().asset().texturePath();
    }

    public MoobloomRenderState createRenderState() {
        return new MoobloomRenderState();
    }

    public void extractRenderState(MoobloomEntity p_364800_, MoobloomRenderState p_401182_, float p_360614_) {
        super.extractRenderState((LivingEntity)p_364800_, (LivingEntityRenderState)p_401182_, p_360614_);
        p_401182_.variant = (MoobloomVariant)p_364800_.getVariant().value();
    }

    public void submit(MoobloomRenderState p_427824_, PoseStack p_423787_, SubmitNodeCollector p_424901_, CameraRenderState p_422963_) {
        if (p_427824_.variant != null) {
            this.model = (MoobloomModel)this.models.get(p_427824_.variant.modelAndTexture().model()).getModel(p_427824_.isBaby);
            super.submit((LivingEntityRenderState)p_427824_, p_423787_, p_424901_, p_422963_);
        }
    }
}

