/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.moobloom.variant;

import com.belgie.moobloom.ModLootTables;
import com.belgie.moobloom.Registry;
import com.belgie.moobloom.Tags;
import com.belgie.moobloom.variant.MoobloomVariant;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.PriorityProvider;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;

public class MoobloomVariants {
    public static final ResourceKey<MoobloomVariant> POPPY = MoobloomVariants.createKey("poppy");
    public static final ResourceKey<MoobloomVariant> DANDELION = MoobloomVariants.createKey("dandelion");
    public static final ResourceKey<MoobloomVariant> BLUE_ORCHID = MoobloomVariants.createKey("blue_orchid");
    public static final ResourceKey<MoobloomVariant> OXEYE = MoobloomVariants.createKey("oxeye_daisy");
    public static final ResourceKey<MoobloomVariant> PINK_TULIP = MoobloomVariants.createKey("pink_tulip");
    public static final ResourceKey<MoobloomVariant> ORANGE_TULIP = MoobloomVariants.createKey("orange_tulip");
    public static final ResourceKey<MoobloomVariant> RED_TULIP = MoobloomVariants.createKey("red_tulip");
    public static final ResourceKey<MoobloomVariant> WHITE_TULIP = MoobloomVariants.createKey("white_tulip");
    public static final ResourceKey<MoobloomVariant> ALLIUM = MoobloomVariants.createKey("allium");
    public static final ResourceKey<MoobloomVariant> AZURE = MoobloomVariants.createKey("azure_bluet");
    public static final ResourceKey<MoobloomVariant> LILY_VALLEY = MoobloomVariants.createKey("lily_of_the_valley");
    public static final ResourceKey<MoobloomVariant> CORNFLOWER = MoobloomVariants.createKey("cornflower");
    public static final ResourceKey<MoobloomVariant> CACTUS_FLOWER = MoobloomVariants.createKey("cactus_flower");
    public static final ResourceKey<MoobloomVariant> WITHER_ROSE = MoobloomVariants.createKey("wither_rose");
    public static final ResourceKey<MoobloomVariant> TORCHFLOWER = MoobloomVariants.createKey("torchflower");
    public static final ResourceKey<MoobloomVariant> EYEBLOSSOM_OPEN = MoobloomVariants.createKey("open_eyeblossom");
    public static final ResourceKey<MoobloomVariant> EYEBLOSSOM_CLOSED = MoobloomVariants.createKey("closed_eyeblossom");
    public static final ResourceKey<MoobloomVariant> DEFAULT = POPPY;

    private static ResourceKey<MoobloomVariant> createKey(String name) {
        return ResourceKey.create(Registry.MOOBLOOM_VARIANT_REGISTRY_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"moobloom", (String)name));
    }

    public static Optional<Holder.Reference<MoobloomVariant>> selectVariantToSpawn(RandomSource p_401128_, RegistryAccess p_401407_, SpawnContext p_401187_) {
        return PriorityProvider.pick((Stream)p_401407_.lookupOrThrow(Registry.MOOBLOOM_VARIANT_REGISTRY_KEY).listElements(), Holder::value, (RandomSource)p_401128_, (Object)p_401187_);
    }

    private static void register(BootstrapContext<MoobloomVariant> p_401233_, ResourceKey<MoobloomVariant> p_401326_, MoobloomVariant.ModelType p_401177_, String p_401134_, TagKey<Biome> p_401160_, boolean allowBonemeal, int bonemealcooldown, ResourceKey<LootTable> shearloot, boolean placeflowers, BlockState block) {
        HolderSet.Named holderset = p_401233_.lookup(Registries.BIOME).getOrThrow(p_401160_);
        MoobloomVariants.register(p_401233_, p_401326_, p_401177_, p_401134_, SpawnPrioritySelectors.single((SpawnCondition)new BiomeCheck((HolderSet)holderset), (int)1), allowBonemeal, bonemealcooldown, shearloot, placeflowers, block);
    }

    private static void register(BootstrapContext<MoobloomVariant> p_401143_, ResourceKey<MoobloomVariant> p_401412_, MoobloomVariant.ModelType p_401209_, String p_401425_, SpawnPrioritySelectors p_401210_, boolean allowBonemeal, int bonemealcooldown, ResourceKey<LootTable> shearloot, boolean placeflowers, BlockState block) {
        ResourceLocation resourcelocation = ResourceLocation.fromNamespaceAndPath((String)"moobloom", (String)("entity/moobloom/" + p_401425_));
        p_401143_.register(p_401412_, (Object)new MoobloomVariant((ModelAndTexture<MoobloomVariant.ModelType>)new ModelAndTexture((Object)p_401209_, resourcelocation), p_401210_, allowBonemeal, bonemealcooldown, shearloot, placeflowers, block));
    }

    public static void bootstrap(BootstrapContext<MoobloomVariant> context) {
        MoobloomVariants.register(context, POPPY, MoobloomVariant.ModelType.NORMAL, "red", Tags.COMMON_MOOBLOOMS_SPAWN_IN, true, 600, ModLootTables.SHEAR_POPPY, true, Blocks.POPPY.defaultBlockState());
        MoobloomVariants.register(context, DANDELION, MoobloomVariant.ModelType.NORMAL, "yellow", Tags.COMMON_MOOBLOOMS_SPAWN_IN, true, 600, ModLootTables.SHEAR_DANDELION, true, Blocks.DANDELION.defaultBlockState());
        MoobloomVariants.register(context, BLUE_ORCHID, MoobloomVariant.ModelType.NORMAL, "light_blue", (TagKey<Biome>)BiomeTags.HAS_SWAMP_HUT, true, 600, ModLootTables.SHEAR_BLUE_ORCHID, true, Blocks.BLUE_ORCHID.defaultBlockState());
        MoobloomVariants.register(context, OXEYE, MoobloomVariant.ModelType.NORMAL, "light_gray", Tags.COMMON_MOOBLOOMS_SPAWN_IN, true, 600, ModLootTables.SHEAR_OXEYE, true, Blocks.OXEYE_DAISY.defaultBlockState());
        MoobloomVariants.register(context, PINK_TULIP, MoobloomVariant.ModelType.NORMAL, "pink", Tags.COMMON_MOOBLOOMS_SPAWN_IN, true, 600, ModLootTables.SHEAR_PINK_TULIP, true, Blocks.PINK_TULIP.defaultBlockState());
        MoobloomVariants.register(context, WHITE_TULIP, MoobloomVariant.ModelType.NORMAL, "light_gray", Tags.COMMON_MOOBLOOMS_SPAWN_IN, true, 600, ModLootTables.SHEAR_WHITE_TULIP, true, Blocks.WHITE_TULIP.defaultBlockState());
        MoobloomVariants.register(context, ORANGE_TULIP, MoobloomVariant.ModelType.NORMAL, "orange", Tags.COMMON_MOOBLOOMS_SPAWN_IN, true, 600, ModLootTables.SHEAR_ORANGE_TULIP, true, Blocks.ORANGE_TULIP.defaultBlockState());
        MoobloomVariants.register(context, RED_TULIP, MoobloomVariant.ModelType.NORMAL, "red", Tags.COMMON_MOOBLOOMS_SPAWN_IN, true, 600, ModLootTables.SHEAR_RED_TULIP, true, Blocks.RED_TULIP.defaultBlockState());
        MoobloomVariants.register(context, ALLIUM, MoobloomVariant.ModelType.NORMAL, "purple", Tags.COMMON_MOOBLOOMS_SPAWN_IN, true, 600, ModLootTables.SHEAR_ALLIUM, true, Blocks.ALLIUM.defaultBlockState());
        MoobloomVariants.register(context, AZURE, MoobloomVariant.ModelType.NORMAL, "light_gray", Tags.COMMON_MOOBLOOMS_SPAWN_IN, true, 600, ModLootTables.SHEAR_AZURE, true, Blocks.AZURE_BLUET.defaultBlockState());
        MoobloomVariants.register(context, LILY_VALLEY, MoobloomVariant.ModelType.NORMAL, "light_gray", Tags.COMMON_MOOBLOOMS_SPAWN_IN, true, 600, ModLootTables.SHEAR_LILY, true, Blocks.LILY_OF_THE_VALLEY.defaultBlockState());
        MoobloomVariants.register(context, CORNFLOWER, MoobloomVariant.ModelType.NORMAL, "blue", Tags.COMMON_MOOBLOOMS_SPAWN_IN, true, 600, ModLootTables.SHEAR_CORNFLOWER, true, Blocks.CORNFLOWER.defaultBlockState());
        MoobloomVariants.register(context, WITHER_ROSE, MoobloomVariant.ModelType.NORMAL, "black", Tags.IS_SOUL_SAND_VALLEY, false, 600, ModLootTables.SHEAR_WITHER, false, Blocks.WITHER_ROSE.defaultBlockState());
        MoobloomVariants.register(context, EYEBLOSSOM_CLOSED, MoobloomVariant.ModelType.NORMAL, "pale", Tags.IS_PALE_GARDEN, false, 600, ModLootTables.SHEAR_CLOSED_EYEBLOSSOM, false, Blocks.CLOSED_EYEBLOSSOM.defaultBlockState());
        MoobloomVariants.register(context, EYEBLOSSOM_OPEN, MoobloomVariant.ModelType.NORMAL, "pale", Tags.IS_PALE_GARDEN, false, 600, ModLootTables.SHEAR_OPEN_EYEBLOSSOM, false, Blocks.OPEN_EYEBLOSSOM.defaultBlockState());
        MoobloomVariants.register(context, TORCHFLOWER, MoobloomVariant.ModelType.NORMAL, "green", (TagKey<Biome>)BiomeTags.HAS_TRAIL_RUINS, false, 600, ModLootTables.SHEAR_TORCHFLOWER, false, Blocks.TORCHFLOWER.defaultBlockState());
        MoobloomVariants.register(context, CACTUS_FLOWER, MoobloomVariant.ModelType.NORMAL, "pink", (TagKey<Biome>)BiomeTags.HAS_DESERT_PYRAMID, false, 600, ModLootTables.SHEAR_CACTUS_FLOWER, false, Blocks.CACTUS_FLOWER.defaultBlockState());
    }
}

