/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.moobloom;

import com.belgie.moobloom.MoobloomEntity;
import com.belgie.moobloom.MoobloomLayer;
import com.belgie.moobloom.MoobloomRenderState;
import com.belgie.moobloom.variant.MoobloomVariant;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.model.AdultAndBabyModelPair;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class MoobloomRenderer
extends MobRenderer<MoobloomEntity, MoobloomRenderState, CowModel> {
    private final Map<MoobloomVariant.ModelType, AdultAndBabyModelPair<CowModel>> models;

    public MoobloomRenderer(EntityRendererProvider.Context p_173956_) {
        super(p_173956_, (EntityModel)new CowModel(p_173956_.bakeLayer(ModelLayers.COW)), 0.7f);
        this.models = MoobloomRenderer.bakeModels(p_173956_);
        this.addLayer(new MoobloomLayer((RenderLayerParent<MoobloomRenderState, CowModel>)this, p_173956_.getBlockRenderDispatcher()));
    }

    private static Map<MoobloomVariant.ModelType, AdultAndBabyModelPair<CowModel>> bakeModels(EntityRendererProvider.Context p_401303_) {
        return Maps.newEnumMap(Map.of(MoobloomVariant.ModelType.NORMAL, new AdultAndBabyModelPair((Model)new CowModel(p_401303_.bakeLayer(ModelLayers.COW)), (Model)new CowModel(p_401303_.bakeLayer(ModelLayers.COW_BABY))), MoobloomVariant.ModelType.WARM, new AdultAndBabyModelPair((Model)new CowModel(p_401303_.bakeLayer(ModelLayers.WARM_COW)), (Model)new CowModel(p_401303_.bakeLayer(ModelLayers.WARM_COW_BABY))), MoobloomVariant.ModelType.COLD, new AdultAndBabyModelPair((Model)new CowModel(p_401303_.bakeLayer(ModelLayers.COLD_COW)), (Model)new CowModel(p_401303_.bakeLayer(ModelLayers.COLD_COW_BABY)))));
    }

    public ResourceLocation getTextureLocation(MoobloomRenderState p_401372_) {
        return p_401372_.variant == null ? MissingTextureAtlasSprite.getLocation() : p_401372_.variant.modelAndTexture().asset().texturePath();
    }

    public MoobloomRenderState createRenderState() {
        return new MoobloomRenderState();
    }

    public void extractRenderState(MoobloomEntity p_364800_, MoobloomRenderState p_401182_, float p_360614_) {
        super.extractRenderState((LivingEntity)p_364800_, (LivingEntityRenderState)p_401182_, p_360614_);
        p_401182_.variant = (MoobloomVariant)p_364800_.getVariant().value();
    }

    public void render(MoobloomRenderState p_401408_, PoseStack p_401206_, MultiBufferSource p_401086_, int p_401222_) {
        if (p_401408_.variant != null) {
            this.model = (CowModel)this.models.get(p_401408_.variant.modelAndTexture().model()).getModel(p_401408_.isBaby);
            super.render((LivingEntityRenderState)p_401408_, p_401206_, p_401086_, p_401222_);
        }
    }
}

