/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.moobloom.variant;

import com.belgie.moobloom.ModLootTables;
import com.belgie.moobloom.Registry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.PriorityProvider;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;

public record MoobloomVariant(ModelAndTexture<ModelType> modelAndTexture, SpawnPrioritySelectors spawnConditions, boolean allowBonemeal, int bonemealcooldown, ResourceKey<LootTable> shearloot, boolean placeflowers, BlockState block) implements PriorityProvider<SpawnContext, SpawnCondition>
{
    public static final Codec<MoobloomVariant> DIRECT_CODEC = RecordCodecBuilder.create(p_401151_ -> p_401151_.group((App)ModelAndTexture.codec(ModelType.CODEC, (Object)((Object)ModelType.NORMAL)).forGetter(MoobloomVariant::modelAndTexture), (App)SpawnPrioritySelectors.CODEC.fieldOf("spawn_conditions").forGetter(MoobloomVariant::spawnConditions), (App)Codec.BOOL.fieldOf("allowBonemeal").forGetter(MoobloomVariant::allowBonemeal), (App)Codec.INT.fieldOf("bonemeal_cooldown").forGetter(MoobloomVariant::bonemealcooldown), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("shear_loot_table").forGetter(MoobloomVariant::shearloot), (App)Codec.BOOL.fieldOf("can_place_flowers").forGetter(MoobloomVariant::placeflowers), (App)BlockState.CODEC.fieldOf("block").forGetter(MoobloomVariant::block)).apply((Applicative)p_401151_, MoobloomVariant::new));
    public static final Codec<MoobloomVariant> NETWORK_CODEC = RecordCodecBuilder.create(p_401154_ -> p_401154_.group((App)ModelAndTexture.codec(ModelType.CODEC, (Object)((Object)ModelType.NORMAL)).forGetter(MoobloomVariant::modelAndTexture)).apply((Applicative)p_401154_, MoobloomVariant::new));
    public static final Codec<Holder<MoobloomVariant>> CODEC = RegistryFixedCodec.create(Registry.MOOBLOOM_VARIANT_REGISTRY_KEY);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<MoobloomVariant>> STREAM_CODEC = ByteBufCodecs.holderRegistry(Registry.MOOBLOOM_VARIANT_REGISTRY_KEY);

    private MoobloomVariant(ModelAndTexture<ModelType> p_401192_) {
        this(p_401192_, SpawnPrioritySelectors.EMPTY, true, 600, ModLootTables.SHEAR_POPPY, true, Blocks.POPPY.defaultBlockState());
    }

    public List<PriorityProvider.Selector<SpawnContext, SpawnCondition>> selectors() {
        return this.spawnConditions.selectors();
    }

    public static enum ModelType implements StringRepresentable
    {
        NORMAL("normal"),
        COLD("cold"),
        WARM("warm");

        public static final Codec<ModelType> CODEC;
        private final String name;

        private ModelType(String p_401310_) {
            this.name = p_401310_;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ModelType::values);
        }
    }
}

