/*
 * Decompiled with CFR 0.152.
 */
package com.vinurl.exe;

import com.vinurl.client.VinURLClient;
import com.vinurl.util.Constants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.SystemUtils;

public enum Executable {
    YT_DLP("yt-dlp", "yt-dlp/yt-dlp", String.format("yt-dlp%s", SystemUtils.IS_OS_LINUX ? "_linux" : (SystemUtils.IS_OS_MAC ? "_macos" : ".exe"))),
    FFPROBE("ffprobe", "eugeneware/ffmpeg-static", String.format("ffprobe-%s-x64", SystemUtils.IS_OS_LINUX ? "linux" : (SystemUtils.IS_OS_MAC ? "darwin" : "win32"))),
    FFMPEG("ffmpeg", "eugeneware/ffmpeg-static", String.format("ffmpeg-%s-x64", SystemUtils.IS_OS_LINUX ? "linux" : (SystemUtils.IS_OS_MAC ? "darwin" : "win32")));

    public final Path DIRECTORY = Constants.VINURLPATH.resolve("executables");
    private final String FILE_NAME;
    private final String REPOSITORY_NAME;
    private final String REPOSITORY_FILE;
    private final Path FILE_PATH;
    private final Path VERSION_PATH;
    private final ConcurrentHashMap<String, ProcessStream> activeProcesses = new ConcurrentHashMap();

    private Executable(String fileName, String repositoryName, String repositoryFile) {
        this.FILE_NAME = fileName;
        this.REPOSITORY_NAME = repositoryName;
        this.REPOSITORY_FILE = repositoryFile;
        this.FILE_PATH = this.DIRECTORY.resolve(this.FILE_NAME + (SystemUtils.IS_OS_WINDOWS ? ".exe" : ""));
        this.VERSION_PATH = this.DIRECTORY.resolve(this.FILE_NAME + ".version");
    }

    public boolean registerProcess(String id, ProcessStream processStream) {
        return this.activeProcesses.computeIfAbsent(id, k -> {
            processStream.onExit(() -> this.activeProcesses.remove(id));
            return processStream;
        }) == processStream;
    }

    public boolean isProcessRunning(String id) {
        return this.activeProcesses.containsKey(id);
    }

    public ProcessStream getProcessStream(String id) {
        return this.activeProcesses.get(id);
    }

    public void killProcess(String id) {
        ProcessStream stream = this.activeProcesses.remove(id);
        if (stream != null && stream.process != null) {
            try {
                stream.process.descendants().forEach(ph -> {
                    ph.destroyForcibly();
                    ph.onExit().join();
                });
                stream.process.destroyForcibly();
                stream.process.onExit().join();
            }
            catch (Exception e) {
                Constants.LOGGER.error("Failed to kill process with ID: {}", (Object)id, (Object)e);
            }
        }
    }

    public void killAllProcesses() {
        for (String id : Set.copyOf(this.activeProcesses.keySet())) {
            this.killProcess(id);
        }
    }

    public boolean checkForExecutable() {
        if (this.DIRECTORY.toFile().exists() || this.DIRECTORY.toFile().mkdirs()) {
            if (!this.FILE_PATH.toFile().exists()) {
                return this.downloadExecutable();
            }
            if (VinURLClient.CONFIG.updatesOnStartup()) {
                this.checkForUpdates();
            }
            return true;
        }
        return false;
    }

    public boolean checkForUpdates() {
        return !this.currentVersion().equals(this.latestVersion()) && this.downloadExecutable();
    }

    private boolean downloadExecutable() {
        boolean bl;
        block18: {
            InputStream inputStream = this.getDownloadInputStream();
            try {
                if (this.REPOSITORY_FILE.endsWith(".zip")) {
                    try (ZipInputStream zipInput = new ZipInputStream(inputStream);){
                        ZipEntry zipEntry = zipInput.getNextEntry();
                        while (zipEntry != null) {
                            if (zipEntry.getName().endsWith(this.FILE_NAME + (SystemUtils.IS_OS_WINDOWS ? ".exe" : ""))) {
                                Files.copy(zipInput, this.FILE_PATH, StandardCopyOption.REPLACE_EXISTING);
                            }
                            zipEntry = zipInput.getNextEntry();
                        }
                    }
                } else {
                    Files.copy(inputStream, this.FILE_PATH, StandardCopyOption.REPLACE_EXISTING);
                }
                if (SystemUtils.IS_OS_UNIX) {
                    Runtime.getRuntime().exec(new String[]{"chmod", "+x", this.FILE_PATH.toString()});
                }
                bl = this.createVersionFile(this.latestVersion());
                if (inputStream == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    private boolean createVersionFile(String version) {
        try {
            Files.writeString(this.VERSION_PATH, (CharSequence)version, new OpenOption[0]);
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public String currentVersion() {
        try {
            return Files.readString(this.VERSION_PATH);
        }
        catch (IOException e) {
            return "";
        }
    }

    private String latestVersion() {
        String string;
        String url = String.format("https://api.github.com/repos/%s/releases/latest", this.REPOSITORY_NAME);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new URI(url).toURL().openStream()));
        try {
            string = reader.readLine().split("\"tag_name\":\"")[1].split("\",\"target_commitish\"")[0];
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ArrayIndexOutOfBoundsException | URISyntaxException e) {
                return "";
            }
        }
        reader.close();
        return string;
    }

    private InputStream getDownloadInputStream() throws IOException, URISyntaxException {
        String url = String.format("https://github.com/%s/releases/latest/download/%s", this.REPOSITORY_NAME, this.REPOSITORY_FILE);
        return new URI(url).toURL().openStream();
    }

    public ProcessStream executeCommand(String id, String ... arguments) {
        return new ProcessStream(id, arguments);
    }

    public class ProcessStream {
        private final String id;
        private final String[] arguments;
        private final SubmissionPublisher<String> publisher = new SubmissionPublisher();
        private final ConcurrentHashMap<String, Flow.Subscription> subscriptions = new ConcurrentHashMap();
        private Process process;

        public ProcessStream(String id, String ... arguments) {
            this.id = id;
            this.arguments = arguments;
            if (Executable.this.registerProcess(id, this)) {
                CompletableFuture.runAsync(this::startProcess);
            }
        }

        public SubscriberBuilder subscribe(String subscriberId) {
            return new SubscriberBuilder(subscriberId);
        }

        public int subscriberCount() {
            return this.subscriptions.size();
        }

        public void unsubscribe(String subscriberId) {
            Flow.Subscription subscription = this.subscriptions.remove(subscriberId);
            if (subscription != null) {
                subscription.cancel();
            }
        }

        public void onExit(Runnable callback) {
            if (this.process != null) {
                this.process.onExit().thenRun(() -> {
                    ((ConcurrentHashMap.KeySetView)this.subscriptions.keySet()).forEach(this::unsubscribe);
                    callback.run();
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startProcess() {
            try {
                this.process = new ProcessBuilder(new String[0]).command((String[])Stream.concat(Stream.of(Executable.this.FILE_PATH.toString()), Stream.of(this.arguments)).toArray(String[]::new)).redirectErrorStream(true).start();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null && !this.publisher.isClosed()) {
                        this.publisher.submit(line);
                    }
                }
                int exitCode = this.process.waitFor();
                if (exitCode == 0) {
                    this.publisher.close();
                } else {
                    this.publisher.closeExceptionally(new IOException("Process failed with code: " + exitCode));
                }
            }
            catch (IOException | InterruptedException e) {
                this.publisher.closeExceptionally(e);
            }
            finally {
                Executable.this.killProcess(this.id);
            }
        }

        public class SubscriberBuilder {
            private final String subscriberId;
            private Consumer<String> onOutput = s -> {};
            private Consumer<Throwable> onError = t -> {};
            private Runnable onComplete = () -> {};

            public SubscriberBuilder(String subscriberId) {
                this.subscriberId = subscriberId;
            }

            public SubscriberBuilder onOutput(Consumer<String> consumer) {
                this.onOutput = consumer;
                return this;
            }

            public SubscriberBuilder onError(Consumer<Throwable> consumer) {
                this.onError = consumer;
                return this;
            }

            public SubscriberBuilder onComplete(Runnable runnable) {
                this.onComplete = runnable;
                return this;
            }

            public void start() {
                ProcessStream.this.publisher.subscribe(new Flow.Subscriber<String>(){

                    @Override
                    public void onSubscribe(Flow.Subscription subscription) {
                        ProcessStream.this.subscriptions.put(SubscriberBuilder.this.subscriberId, subscription);
                        subscription.request(Long.MAX_VALUE);
                    }

                    @Override
                    public void onNext(String item) {
                        SubscriberBuilder.this.onOutput.accept(item);
                    }

                    @Override
                    public void onError(Throwable throwable) {
                        ProcessStream.this.subscriptions.remove(SubscriberBuilder.this.subscriberId);
                        SubscriberBuilder.this.onError.accept(throwable);
                    }

                    @Override
                    public void onComplete() {
                        ProcessStream.this.subscriptions.remove(SubscriberBuilder.this.subscriberId);
                        SubscriberBuilder.this.onComplete.run();
                    }
                });
            }
        }
    }
}

