/*
 * Decompiled with CFR 0.152.
 */
package com.vinurl.client;

import com.jcraft.jorbis.JOrbisException;
import com.jcraft.jorbis.VorbisFile;
import com.vinurl.client.FileSound;
import com.vinurl.client.VinURLClient;
import com.vinurl.exe.Executable;
import com.vinurl.gui.ProgressOverlay;
import com.vinurl.util.Constants;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.class_1113;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;

public class SoundManager {
    public static final Path AUDIO_DIRECTORY = Constants.VINURLPATH.resolve("downloads");
    private static final ConcurrentHashMap<class_243, FileSound> playingSounds = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> descriptionCache = new ConcurrentHashMap();

    public static void downloadSound(String url, String fileName) {
        if (VinURLClient.CLIENT.field_1724 == null) {
            return;
        }
        ProgressOverlay.set(fileName, 0);
        Executable.YT_DLP.executeCommand(fileName + "/download", url, "-x", "-q", "--progress", "--add-metadata", "--no-playlist", "--progress-template", "PROGRESS: %(progress._percent)d", "--newline", "--break-match-filter", "ext~=3gp|aac|flv|m4a|mov|mp3|mp4|ogg|wav|webm|opus", "--audio-format", "vorbis", "--audio-quality", VinURLClient.CONFIG.audioBitrate().getValue(), "--postprocessor-args", "ffmpeg:-ac 1 -c:a libvorbis", "-P", AUDIO_DIRECTORY.toString(), "--ffmpeg-location", Executable.FFMPEG.DIRECTORY.toString(), "-o", fileName + ".%(ext)s").subscribe("main").onOutput(line -> {
            String type = line.substring(0, line.indexOf(58) + 1);
            String message = line.substring(type.length()).trim();
            switch (type) {
                case "PROGRESS:": {
                    ProgressOverlay.set(fileName, Integer.parseInt(message));
                    break;
                }
                case "WARNING:": {
                    Constants.LOGGER.warn(message);
                    break;
                }
                case "ERROR:": {
                    Constants.LOGGER.error(message);
                    break;
                }
                default: {
                    Constants.LOGGER.info(line);
                }
            }
        }).onError(error -> {
            ProgressOverlay.stopFailed(fileName);
            SoundManager.deleteSound(fileName);
        }).onComplete(() -> {
            ProgressOverlay.stop(fileName);
            SoundManager.descriptionToCache(fileName);
        }).start();
    }

    public static void deleteSound(String fileName) {
        File[] filesToDelete = AUDIO_DIRECTORY.toFile().listFiles(file -> file.getName().contains(fileName));
        if (filesToDelete == null) {
            return;
        }
        for (File file2 : filesToDelete) {
            FileUtils.deleteQuietly((File)file2);
        }
    }

    public static void playSound(class_243 position) {
        FileSound fileSound = playingSounds.get(position);
        if (fileSound != null) {
            VinURLClient.CLIENT.method_1483().method_4873((class_1113)fileSound);
            VinURLClient.CLIENT.field_1705.method_1732((class_2561)class_2561.method_43470((String)SoundManager.getDescription(fileSound.fileName)));
        }
    }

    public static void stopSound(class_243 position) {
        VinURLClient.CLIENT.method_1483().method_4870((class_1113)playingSounds.remove(position));
    }

    public static void addSound(String fileName, class_243 position, boolean loop) {
        playingSounds.put(position, new FileSound(fileName, position, loop));
    }

    public static void queueSound(String fileName, class_243 position) {
        Executable.YT_DLP.getProcessStream(fileName + "/download").subscribe(position.toString()).onComplete(() -> SoundManager.playSound(position)).start();
    }

    public static String getDescription(String fileName) {
        return Optional.ofNullable(SoundManager.descriptionFromCache(fileName)).orElseGet(() -> SoundManager.descriptionToCache(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getOggAttribute(String fileName, String attribute) {
        VorbisFile vorbisFile = null;
        try {
            vorbisFile = new VorbisFile(SoundManager.getAudioFile(fileName).toString());
            String metadata = vorbisFile.getComment(0).toString();
            String filter = "Comment: " + attribute + "=";
            String string = Stream.of(metadata.split("\n")).filter(line -> line.startsWith(filter)).map(line -> line.substring(filter.length())).findFirst().orElse("N/A");
            return string;
        }
        catch (JOrbisException e) {
            String string = "N/A";
            return string;
        }
        finally {
            if (vorbisFile != null) {
                try {
                    vorbisFile.close();
                }
                catch (IOException e) {
                    Constants.LOGGER.error("Error closing vorbis file", (Throwable)e);
                }
            }
        }
    }

    public static String descriptionToCache(String fileName) {
        descriptionCache.remove(fileName);
        return descriptionCache.compute(fileName, (k, v) -> {
            String artist = SoundManager.getOggAttribute(fileName, "artist");
            String title = SoundManager.getOggAttribute(fileName, "title");
            return (artist + " - " + title).replaceAll("[\ufe00-\ufe0f]", "");
        });
    }

    public static String descriptionFromCache(String fileName) {
        return descriptionCache.get(fileName);
    }

    public static String getBaseURL(String url) {
        try {
            URI baseURL = new URI(url);
            return baseURL.getScheme() + "://" + baseURL.getHost();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static File getAudioFile(String fileName) {
        return AUDIO_DIRECTORY.resolve(fileName + ".ogg").toFile();
    }

    public static String hashURL(String url) {
        return url == null || url.isEmpty() ? "" : DigestUtils.sha256Hex((String)url);
    }
}

