/*
 * Decompiled with CFR 0.152.
 */
package com.vinurl.client;

import io.wispforest.owo.config.annotation.Config;
import io.wispforest.owo.config.annotation.Modmenu;
import io.wispforest.owo.config.annotation.PredicateConstraint;
import io.wispforest.owo.config.annotation.SectionHeader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

@Modmenu(modId="vinurl")
@Config(name="VinURLConfig", wrapperName="VinURLConfig")
public class ClientConfig {
    @SectionHeader(value="general")
    public boolean downloadEnabled = true;
    public boolean updatesOnStartup = true;
    public boolean showDescription = true;
    @PredicateConstraint(value="urlSanitization")
    public List<String> urlWhitelist = new ArrayList<String>(List.of("https://www.youtube.com", "https://soundcloud.com"));
    @SectionHeader(value="audioSettings")
    public AudioQuality audioBitrate = AudioQuality.MEDIUM;

    public static boolean urlSanitization(List<String> list) {
        return list.stream().allMatch(url -> {
            try {
                return new URI((String)url).toURL().toString().equals(url);
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    public static enum AudioQuality {
        LOW("48K"),
        MEDIUM("96K"),
        HIGH("128K");

        private final String value;

        private AudioQuality(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

