/*
 * Decompiled with CFR 0.152.
 */
package com.vinurl.cmd;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vinurl.client.SoundManager;
import com.vinurl.client.VinURLClient;
import com.vinurl.exe.Executable;
import io.wispforest.owo.config.ui.ConfigScreenProviders;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.apache.commons.io.FileUtils;

public class Commands {
    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"vinurl").then(ClientCommandManager.literal((String)"delete").executes(Commands::deleteAudioFiles))).then(ClientCommandManager.literal((String)"update").executes(Commands::updateExecutables))).then(ClientCommandManager.literal((String)"config").executes(Commands::openConfig))));
    }

    private static int deleteAudioFiles(CommandContext<FabricClientCommandSource> ctx) {
        try {
            FileUtils.deleteDirectory((File)SoundManager.AUDIO_DIRECTORY.toFile());
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Deleted all audio files"));
            return 1;
        }
        catch (IOException e) {
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Deleted only non active audio files"));
            return 0;
        }
    }

    private static int updateExecutables(CommandContext<FabricClientCommandSource> ctx) {
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Checking for updates..."));
        CompletableFuture.runAsync(() -> {
            boolean anyUpdate = false;
            for (Executable executable : Executable.values()) {
                String current = executable.currentVersion();
                if (!executable.checkForUpdates()) continue;
                String latest = executable.currentVersion();
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("%s: %s -> %s", new Object[]{executable, current, latest})));
                anyUpdate = true;
            }
            if (!anyUpdate) {
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Everything is up to date!"));
            }
        });
        return 1;
    }

    private static int openConfig(CommandContext<FabricClientCommandSource> ctx) {
        VinURLClient.CLIENT.method_63588(() -> VinURLClient.CLIENT.method_1507((class_437)Objects.requireNonNull(ConfigScreenProviders.get((String)"vinurl")).apply(null)));
        return 0;
    }
}

