/*
 * Decompiled with CFR 0.152.
 */
package com.vinurl.gui;

public class ProgressEntry {
    public static final int MIN = 0;
    public static final int MAX = 100;
    public static final int ERROR = -1;
    public static final long ERROR_TIMEOUT_MILLIS = 2000L;
    public int progress;
    public long stateChangeTime;
    public ProgressState state;

    public ProgressEntry(int progress) {
        this.updateProgress(progress);
    }

    void updateProgress(int progress) {
        this.progress = progress >= 0 && progress <= 100 ? progress : -1;
        this.stateChangeTime = System.currentTimeMillis();
        this.state = switch (this.progress) {
            case -1 -> ProgressState.INTERRUPTED;
            case 100 -> ProgressState.TRANSCODING;
            default -> ProgressState.DOWNLOADING;
        };
    }

    boolean shouldRemove(long now) {
        return this.state == ProgressState.INTERRUPTED && now - this.stateChangeTime >= 2000L;
    }

    public static enum ProgressState {
        DOWNLOADING,
        TRANSCODING,
        INTERRUPTED;


        public String toString() {
            return this.name().charAt(0) + this.name().substring(1).toLowerCase();
        }
    }
}

