/*
 * Decompiled with CFR 0.152.
 */
package com.vinurl.gui;

import com.vinurl.client.VinURLClient;
import com.vinurl.gui.ProgressEntry;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ProgressOverlay {
    private static final int BAR_SIZE = 20;
    private static int batchSize = 0;
    private static final LinkedHashMap<String, ProgressEntry> progressQueue = new LinkedHashMap();

    public static void set(String id, int progressPercent) {
        if (progressQueue.put(id, new ProgressEntry(progressPercent)) == null) {
            ++batchSize;
        }
    }

    public static void stop(String id) {
        if (progressQueue.remove(id) != null && progressQueue.isEmpty()) {
            batchSize = 0;
        }
    }

    public static void stopFailed(String id) {
        progressQueue.put(id, new ProgressEntry(-1));
    }

    public static void render(class_332 context) {
        if (progressQueue.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        Map.Entry<String, ProgressEntry> firstEntry = progressQueue.entrySet().iterator().next();
        String currentId = firstEntry.getKey();
        ProgressEntry entry = firstEntry.getValue();
        if (entry.shouldRemove(now)) {
            ProgressOverlay.stop(currentId);
            return;
        }
        class_5250 progress = switch (entry.state) {
            case ProgressEntry.ProgressState.INTERRUPTED -> class_2561.method_43470((String)String.format("%d/%d ", batchSize - (progressQueue.size() - 1), batchSize)).method_10852(ProgressOverlay.createProgressText(20, class_124.field_1061));
            case ProgressEntry.ProgressState.TRANSCODING -> {
                int animationStep = (int)((now - entry.stateChangeTime) / 100L) % 20;
                yield class_2561.method_43470((String)String.format("%d/%d ", batchSize - (progressQueue.size() - 1), batchSize)).method_10852(ProgressOverlay.createProgressText(animationStep, class_124.field_1080)).method_10852(ProgressOverlay.createProgressText(1, class_124.field_1078)).method_10852(ProgressOverlay.createProgressText(19 - animationStep, class_124.field_1080));
            }
            default -> {
                int progressBars = 20 * entry.progress / 100;
                yield class_2561.method_43470((String)String.format("%d/%d ", batchSize - (progressQueue.size() - 1), batchSize)).method_10852(ProgressOverlay.createProgressText(progressBars, class_124.field_1060)).method_10852(ProgressOverlay.createProgressText(20 - progressBars, class_124.field_1080));
            }
        };
        ProgressOverlay.renderText(context, (class_2561)class_2561.method_43470((String)entry.state.toString()), 72);
        ProgressOverlay.renderText(context, (class_2561)progress, 62);
    }

    private static class_2561 createProgressText(int count, class_124 formatting) {
        return class_2561.method_43470((String)"|".repeat(count)).method_27692(formatting);
    }

    private static void renderText(class_332 context, class_2561 text, int offset) {
        context.method_27535(VinURLClient.CLIENT.field_1772, text, (VinURLClient.CLIENT.method_22683().method_4486() - VinURLClient.CLIENT.field_1772.method_27525((class_5348)text)) / 2, VinURLClient.CLIENT.method_22683().method_4502() - offset, 0xFFFFFF);
    }
}

