/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.api.hologram;

import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.data.property.Visibility;
import de.oliver.fancyholograms.libs.chatcolorhandler.ModernChatColorHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Hologram {
    public static final int LINE_WIDTH = 1000;
    public static final Color TRANSPARENT = Color.fromARGB((int)0);
    protected static final int MINIMUM_PROTOCOL_VERSION = 762;
    @NotNull
    protected final HologramData data;
    @NotNull
    protected final Set<UUID> viewers = new HashSet<UUID>();

    protected Hologram(@NotNull HologramData data) {
        this.data = data;
    }

    @NotNull
    public String getName() {
        return this.data.getName();
    }

    @NotNull
    public final HologramData getData() {
        return this.data;
    }

    public abstract int getEntityId();

    @Deprecated(forRemoval=true, since="2.4.1")
    @ApiStatus.Internal
    @Nullable
    public abstract Display getDisplayEntity();

    protected abstract void create();

    protected abstract void delete();

    protected abstract void update();

    protected abstract boolean show(@NotNull Player var1);

    protected abstract boolean hide(@NotNull Player var1);

    protected abstract void refresh(@NotNull Player var1);

    public final void createHologram() {
        this.create();
    }

    public final void deleteHologram() {
        this.delete();
    }

    public final void showHologram(Collection<? extends Player> players) {
        players.forEach(this::showHologram);
    }

    public final void showHologram(Player player) {
        this.viewers.add(player.getUniqueId());
    }

    public final void forceShowHologram(Player player) {
        this.show(player);
        if (this.getData().getVisibility().equals((Object)Visibility.MANUAL)) {
            Visibility.ManualVisibility.addDistantViewer(this, player.getUniqueId());
        }
    }

    public final void hideHologram(Collection<? extends Player> players) {
        players.forEach(this::hideHologram);
    }

    public final void hideHologram(Player player) {
        this.viewers.remove(player.getUniqueId());
    }

    public final void forceHideHologram(Player player) {
        this.hide(player);
        if (this.getData().getVisibility().equals((Object)Visibility.MANUAL)) {
            Visibility.ManualVisibility.removeDistantViewer(this, player.getUniqueId());
        }
    }

    @Deprecated(forRemoval=true)
    public final void updateHologram() {
        this.queueUpdate();
    }

    public final void queueUpdate() {
        this.data.setHasChanges(true);
    }

    public final void forceUpdate() {
        this.update();
    }

    public void refreshForViewers() {
        List<Player> players = this.getViewers().stream().map(Bukkit::getPlayer).toList();
        this.refreshHologram(players);
    }

    public void refreshForViewersInWorld() {
        World world = this.data.getLocation().getWorld();
        List<Player> players = this.getViewers().stream().map(Bukkit::getPlayer).filter(player -> player != null && player.getWorld().equals((Object)world)).toList();
        this.refreshHologram(players);
    }

    public final void refreshHologram(@NotNull Player player) {
        this.refresh(player);
    }

    public final void refreshHologram(@NotNull Collection<? extends Player> players) {
        players.forEach(this::refreshHologram);
    }

    @NotNull
    public final Set<UUID> getViewers() {
        return new HashSet<UUID>(this.viewers);
    }

    public final boolean isViewer(@NotNull Player player) {
        return this.isViewer(player.getUniqueId());
    }

    public final boolean isViewer(@NotNull UUID player) {
        return this.viewers.contains(player);
    }

    protected boolean shouldShowTo(@NotNull Player player) {
        if (!this.meetsVisibilityConditions(player)) {
            return false;
        }
        return this.isWithinVisibilityDistance(player);
    }

    public boolean meetsVisibilityConditions(@NotNull Player player) {
        return this.getData().getVisibility().canSee(player, this);
    }

    public boolean isWithinVisibilityDistance(@NotNull Player player) {
        Location location = this.getData().getLocation();
        if (!location.getWorld().equals((Object)player.getWorld())) {
            return false;
        }
        int visibilityDistance = this.data.getVisibilityDistance();
        double distanceSquared = location.distanceSquared(player.getLocation());
        return distanceSquared <= (double)(visibilityDistance * visibilityDistance);
    }

    public void updateShownStateFor(Player player) {
        boolean isShown = this.isViewer(player);
        boolean shouldBeShown = this.shouldShowTo(player);
        if (isShown && !shouldBeShown) {
            this.showHologram(player);
        } else if (!isShown && shouldBeShown) {
            this.hideHologram(player);
        }
    }

    public void forceUpdateShownStateFor(Player player) {
        boolean isShown = this.isViewer(player);
        if (this.meetsVisibilityConditions(player)) {
            if (this.isWithinVisibilityDistance(player)) {
                if (!isShown) {
                    this.show(player);
                    if (this.getData().getVisibility().equals((Object)Visibility.MANUAL)) {
                        Visibility.ManualVisibility.removeDistantViewer(this, player.getUniqueId());
                    }
                }
            } else if (isShown) {
                this.hide(player);
                if (this.getData().getVisibility().equals((Object)Visibility.MANUAL)) {
                    Visibility.ManualVisibility.addDistantViewer(this, player.getUniqueId());
                }
            }
        } else if (isShown) {
            this.hide(player);
        }
    }

    public final Component getShownText(@Nullable Player player) {
        HologramData hologramData = this.getData();
        if (!(hologramData instanceof TextHologramData)) {
            return null;
        }
        TextHologramData textData = (TextHologramData)hologramData;
        String text = String.join((CharSequence)"\n", textData.getText());
        return ModernChatColorHandler.translate(text, player);
    }

    public final boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Hologram)) {
            return false;
        }
        Hologram that = (Hologram)o;
        return Objects.equals(this.getData(), that.getData());
    }

    public final int hashCode() {
        return Objects.hash(this.getData());
    }
}

