/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.commands;

import de.oliver.fancyholograms.FancyHolograms;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancyholograms.storage.converter.ConverterTarget;
import de.oliver.fancyholograms.storage.converter.FHConversionRegistry;
import de.oliver.fancyholograms.storage.converter.HologramConversionSession;
import de.oliver.fancylib.MessageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public final class FancyHologramsCMD
extends Command {
    @NotNull
    private final FancyHolograms plugin;

    public FancyHologramsCMD(@NotNull FancyHolograms plugin) {
        super("fancyholograms");
        this.setPermission("fancyholograms.admin");
        this.plugin = plugin;
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return false;
        }
        if (args.length < 1) {
            MessageHelper.info(sender, "/fancyholograms <save|reload|version|convert>");
            return false;
        }
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "save": {
                this.plugin.getHologramsManager().saveHolograms();
                MessageHelper.success(sender, "Saved all holograms");
                break;
            }
            case "reload": {
                this.plugin.getHologramConfiguration().reload(this.plugin);
                this.plugin.getHologramsManager().reloadHolograms();
                this.plugin.reloadCommands();
                MessageHelper.success(sender, "Reloaded config and holograms");
                break;
            }
            case "version": {
                FancyHolograms.get().getHologramThread().submit(() -> FancyHolograms.get().getVersionConfig().checkVersionAndDisplay(sender, false));
                break;
            }
            case "convert": {
                if (args.length < 3) {
                    MessageHelper.info(sender, "Usage: /fancyholograms convert <type> <targets> [args...]");
                    return false;
                }
                String converterId = args[1];
                FHConversionRegistry.getConverterById(converterId).ifPresentOrElse(converter -> {
                    String[] converterArgs = (String[])Arrays.asList(args).subList(2, args.length).toArray(String[]::new);
                    ConverterTarget target = ConverterTarget.ofStringNullable(args[2]);
                    if (target == null) {
                        MessageHelper.error(sender, "Invalid regex for your conversion target!");
                        return;
                    }
                    HologramConversionSession session = new HologramConversionSession(target, sender, converterArgs);
                    try {
                        List<HologramData> holograms = converter.convert(session);
                        for (HologramData data : holograms) {
                            Hologram hologram = this.plugin.getHologramsManager().create(data);
                            this.plugin.getHologramsManager().addHologram(hologram);
                        }
                        this.plugin.getHologramsManager().saveHolograms();
                        MessageHelper.success(sender, String.format("Converted successfully, produced %s total holograms!", holograms.size()));
                    }
                    catch (Exception error) {
                        MessageHelper.error(sender, error.getMessage());
                    }
                }, () -> MessageHelper.error(sender, "That converter is not registered. Look at the developer documentation if you are adding converters."));
                break;
            }
            default: {
                MessageHelper.info(sender, "/fancyholograms <save|reload|version|convert>");
                return false;
            }
        }
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) throws IllegalArgumentException {
        if (args.length < 1) {
            return Collections.emptyList();
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            suggestions.addAll(Arrays.asList("version", "reload", "save", "convert"));
        } else if (Objects.equals(args[0], "convert")) {
            if (args.length == 2) {
                suggestions.addAll(FHConversionRegistry.getAllUsableConverterIds());
            } else if (args.length == 3) {
                String converterId = args[1];
                FHConversionRegistry.getConverterById(converterId).ifPresent(converter -> {
                    suggestions.addAll(converter.getConvertableHolograms());
                    suggestions.add("*");
                });
            }
        }
        String lastArgument = args[args.length - 1];
        return suggestions.stream().filter(alias -> alias.startsWith(lastArgument.toLowerCase(Locale.ROOT))).toList();
    }
}

