/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms;

import com.fancyinnovations.config.ConfigHelper;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyholograms.FancyHolograms;
import de.oliver.fancyholograms.api.FancyHologramsPlugin;
import de.oliver.fancyholograms.api.HologramConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

public final class FancyHologramsConfiguration
implements HologramConfiguration {
    private static final String CONFIG_AUTOSAVE_ENABLED = "saving.autosave.enabled";
    private static final String CONFIG_AUTOSAVE_INTERVAL = "saving.autosave.interval";
    private static final String CONFIG_SAVE_ON_CHANGED = "saving.save_on_changed";
    private static final String CONFIG_LOG_LEVEL = "logging.log_level";
    private static final String CONFIG_LOG_ON_WORLD_LOAD = "logging.log_on_world_load";
    private static final String CONFIG_VERSION_NOTIFICATIONS = "logging.version_notifications";
    private static final String CONFIG_VISIBILITY_DISTANCE = "visibility_distance";
    private static final String CONFIG_REGISTER_COMMANDS = "register_commands";
    private static final String CONFIG_UPDATE_VISIBILITY_INTERVAL = "update_visibility_interval";
    private static final String CONFIG_REPORT_ERRORS_TO_SENTRY = "report_errors_to_sentry";
    private static final String CONFIG_VERSION = "config_version";
    private static final Map<String, List<String>> CONFIG_COMMENTS = Map.of("config_version", List.of("Config version, do not modify."), "saving.autosave.enabled", List.of("Whether autosave is enabled."), "saving.autosave.interval", List.of("The interval at which autosave is performed in minutes."), "saving.save_on_changed", List.of("Whether the plugin should save holograms when they are changed."), "logging.log_level", List.of("The log level for the plugin (DEBUG, INFO, WARN, ERROR)."), "logging.log_on_world_load", List.of("Whether hologram loading should be logged on world loading. Disable this if you load worlds dynamically to prevent console spam."), "logging.version_notifications", List.of("Whether the plugin should send notifications for new updates."), "visibility_distance", List.of("The default visibility distance for holograms."), "register_commands", List.of("Whether the plugin should register its commands."), "update_visibility_interval", List.of("The interval at which hologram visibility is updated in ticks."));
    private boolean autosaveEnabled;
    private int autosaveInterval;
    private boolean saveOnChangedEnabled;
    private String logLevel;
    private boolean hologramLoadLogging;
    private boolean versionNotifs;
    private int defaultVisibilityDistance;
    private boolean registerCommands;
    private int updateVisibilityInterval;

    private void updateChecker(@NotNull FancyHolograms plugin, @NotNull FileConfiguration config) {
        boolean latestVersion = true;
        int configVersion = (Integer)ConfigHelper.getOrDefault(config, CONFIG_VERSION, 0);
        if (configVersion >= 1) {
            this.setOptions(config);
            return;
        }
        plugin.getFancyLogger().warn("Outdated config detected! Attempting to migrate previous settings to new config...", new Property[0]);
        FileConfiguration oldConfig = plugin.getConfig();
        try {
            File backupFile = new File(plugin.getDataFolder(), "config_old.yml");
            oldConfig.save(backupFile);
        }
        catch (IOException e) {
            plugin.getFancyLogger().warn("Unable to backup config to config_old.yml:" + String.valueOf(e), new Property[0]);
        }
        FileConfiguration newConfig = plugin.getConfig();
        Map oldConfigValues = oldConfig.getValues(true);
        Map<String, String> keyMap = Map.of("enable_autosave", CONFIG_AUTOSAVE_ENABLED, "autosave_interval", CONFIG_AUTOSAVE_INTERVAL, "save_on_changed", CONFIG_SAVE_ON_CHANGED, "log_level", CONFIG_LOG_LEVEL, "mute_version_notifications", CONFIG_VERSION_NOTIFICATIONS);
        oldConfigValues.forEach((key, value) -> {
            String newKey = keyMap.getOrDefault(key, null);
            if (newKey != null) {
                if (newKey.equals(CONFIG_VERSION_NOTIFICATIONS)) {
                    newConfig.set(newKey, (Object)((Boolean)value == false ? 1 : 0));
                } else {
                    newConfig.set(newKey, value);
                }
                plugin.getFancyLogger().info("> CONFIG: Set option '" + key + "' to '" + String.valueOf(value) + "' from old config.", new Property[0]);
            } else {
                plugin.getFancyLogger().warn("> CONFIG: Option '" + key + "' is deprecated/invalid! Please migrate this manually from config_old.yml", new Property[0]);
            }
        });
        newConfig.set(CONFIG_VERSION, (Object)1);
        this.setOptions(newConfig);
        CONFIG_COMMENTS.forEach((arg_0, arg_1) -> ((FileConfiguration)config).setInlineComments(arg_0, arg_1));
        plugin.getFancyLogger().info("Configuration has finished migrating. Please double check your settings in config.yml.", new Property[0]);
    }

    private void setOptions(@NotNull FileConfiguration config) {
        this.autosaveEnabled = (Boolean)ConfigHelper.getOrDefault(config, CONFIG_AUTOSAVE_ENABLED, true);
        this.autosaveInterval = (Integer)ConfigHelper.getOrDefault(config, CONFIG_AUTOSAVE_INTERVAL, 15);
        this.saveOnChangedEnabled = (Boolean)ConfigHelper.getOrDefault(config, CONFIG_SAVE_ON_CHANGED, true);
        this.logLevel = (String)ConfigHelper.getOrDefault(config, CONFIG_LOG_LEVEL, "INFO");
        this.hologramLoadLogging = (Boolean)ConfigHelper.getOrDefault(config, CONFIG_LOG_ON_WORLD_LOAD, true);
        this.versionNotifs = (Boolean)ConfigHelper.getOrDefault(config, CONFIG_VERSION_NOTIFICATIONS, true);
        this.defaultVisibilityDistance = (Integer)ConfigHelper.getOrDefault(config, CONFIG_VISIBILITY_DISTANCE, 20);
        this.registerCommands = (Boolean)ConfigHelper.getOrDefault(config, CONFIG_REGISTER_COMMANDS, true);
        this.updateVisibilityInterval = (Integer)ConfigHelper.getOrDefault(config, CONFIG_UPDATE_VISIBILITY_INTERVAL, 20);
        config.set(CONFIG_REPORT_ERRORS_TO_SENTRY, null);
    }

    @Override
    public synchronized void reload(@NotNull FancyHologramsPlugin plugin) {
        FancyHolograms pluginImpl = (FancyHolograms)plugin;
        pluginImpl.reloadConfig();
        FileConfiguration config = pluginImpl.getConfig();
        this.updateChecker(pluginImpl, config);
        if (pluginImpl.isEnabled() && !plugin.getHologramThread().isShutdown()) {
            plugin.getHologramThread().submit(() -> ((FancyHolograms)pluginImpl).saveConfig());
        } else {
            pluginImpl.saveConfig();
        }
    }

    @Override
    public boolean isAutosaveEnabled() {
        return this.autosaveEnabled;
    }

    @Override
    public int getAutosaveInterval() {
        return this.autosaveInterval;
    }

    @Override
    public boolean isSaveOnChangedEnabled() {
        return this.saveOnChangedEnabled;
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public boolean isHologramLoadLogging() {
        return this.hologramLoadLogging;
    }

    @Override
    public boolean areVersionNotificationsEnabled() {
        return this.versionNotifs;
    }

    @Override
    public int getDefaultVisibilityDistance() {
        return this.defaultVisibilityDistance;
    }

    @Override
    public boolean isRegisterCommands() {
        return this.registerCommands;
    }

    @Override
    public int getUpdateVisibilityInterval() {
        return this.updateVisibilityInterval;
    }
}

