/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.commands.hologram;

import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancyholograms.commands.Subcommand;
import de.oliver.fancyholograms.commands.hologram.MoveHereCMD;
import de.oliver.fancylib.MessageHelper;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveToCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender sender, @Nullable Hologram hologram, @NotNull String[] args) {
        if (!sender.hasPermission("fancyholograms.hologram.edit.move_to")) {
            MessageHelper.error(sender, "You don't have the required permission to move a hologram");
            return false;
        }
        if (!(sender instanceof Player)) {
            MessageHelper.error(sender, "You must be a sender to use this command");
            return false;
        }
        Player player = (Player)sender;
        if (args.length < 3) {
            MessageHelper.error((CommandSender)player, "Wrong usage: /hologram help");
            return false;
        }
        Double x = MoveHereCMD.calculateCoordinate(args[3], hologram.getData().getLocation(), player.getLocation(), Location::x);
        Double y = MoveHereCMD.calculateCoordinate(args[4], hologram.getData().getLocation(), player.getLocation(), Location::y);
        Double z = MoveHereCMD.calculateCoordinate(args[5], hologram.getData().getLocation(), player.getLocation(), Location::z);
        if (x == null || y == null || z == null) {
            MessageHelper.error((CommandSender)player, "Could not parse position");
            return false;
        }
        Location location = new Location(player.getWorld(), x.doubleValue(), y.doubleValue(), z.doubleValue(), hologram.getData().getLocation().getYaw(), hologram.getData().getLocation().getPitch());
        if (args.length > 6) {
            Double yaw = MoveHereCMD.calculateCoordinate(args[6], hologram.getData().getLocation(), player.getLocation(), loc -> Float.valueOf(loc.getYaw() + 180.0f));
            if (yaw == null) {
                MessageHelper.error((CommandSender)player, "Could not parse yaw");
                return false;
            }
            location.setYaw(yaw.floatValue() - 180.0f);
        }
        if (args.length > 7) {
            Double pitch = MoveHereCMD.calculateCoordinate(args[7], hologram.getData().getLocation(), player.getLocation(), Location::getPitch);
            if (pitch == null) {
                MessageHelper.error((CommandSender)player, "Could not parse pitch");
                return false;
            }
            location.setPitch(pitch.floatValue());
        }
        return MoveHereCMD.setLocation(player, hologram, location, true);
    }
}

