/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.commands.hologram;

import de.oliver.fancyholograms.FancyHolograms;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.data.property.Visibility;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancyholograms.commands.Subcommand;
import de.oliver.fancylib.MessageHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisibilityCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return Arrays.stream(Visibility.values()).map(Objects::toString).toList();
    }

    @Override
    public boolean run(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        if (!player.hasPermission("fancyholograms.hologram.edit.visibility")) {
            MessageHelper.error(player, "You don't have the required permission to edit a hologram");
            return false;
        }
        Optional<Visibility> optionalVisibility = Visibility.byString(args[3]);
        if (hologram == null || optionalVisibility.isEmpty()) {
            return false;
        }
        Visibility visibility = optionalVisibility.get();
        HologramData copied = hologram.getData().copy(hologram.getName());
        copied.setVisibility(visibility);
        if (hologram.getData().getVisibility() == copied.getVisibility()) {
            MessageHelper.warning(player, "This hologram already has visibility set to " + String.valueOf((Object)visibility));
            return false;
        }
        hologram.getData().setVisibility(copied.getVisibility());
        if (FancyHolograms.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHolograms.get().getHologramStorage().save(hologram);
        }
        MessageHelper.success(player, "Changed visibility to " + String.valueOf((Object)visibility));
        return true;
    }
}

