/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.api.data;

import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyholograms.api.FancyHologramsPlugin;
import de.oliver.fancyholograms.api.data.YamlData;
import de.oliver.fancyholograms.api.data.property.Visibility;
import de.oliver.fancyholograms.api.hologram.HologramType;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HologramData
implements YamlData {
    public static final int DEFAULT_VISIBILITY_DISTANCE = -1;
    public static final Visibility DEFAULT_VISIBILITY = Visibility.ALL;
    public static final boolean DEFAULT_IS_VISIBLE = true;
    public static final boolean DEFAULT_PERSISTENCE = true;
    private final String name;
    private final HologramType type;
    private Location location;
    private boolean hasChanges;
    private int visibilityDistance = -1;
    private Visibility visibility = DEFAULT_VISIBILITY;
    private boolean persistent = true;
    private String linkedNpcName;

    public HologramData(String name, HologramType type, Location location) {
        this.name = name;
        this.type = type;
        this.location = location;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public HologramType getType() {
        return this.type;
    }

    @NotNull
    public Location getLocation() {
        return this.location.clone();
    }

    public HologramData setLocation(@Nullable Location location) {
        this.location = location != null ? location.clone() : null;
        this.setHasChanges(true);
        return this;
    }

    public final boolean hasChanges() {
        return this.hasChanges;
    }

    public final void setHasChanges(boolean hasChanges) {
        this.hasChanges = hasChanges;
    }

    public int getVisibilityDistance() {
        if (this.visibilityDistance > 0) {
            return this.visibilityDistance;
        }
        return FancyHologramsPlugin.get().getHologramConfiguration().getDefaultVisibilityDistance();
    }

    public HologramData setVisibilityDistance(int visibilityDistance) {
        this.visibilityDistance = visibilityDistance;
        this.setHasChanges(true);
        return this;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public HologramData setVisibility(@NotNull Visibility visibility) {
        if (!Objects.equals((Object)this.visibility, (Object)visibility)) {
            this.visibility = visibility;
            this.setHasChanges(true);
            if (this.visibility.equals((Object)Visibility.MANUAL)) {
                Visibility.ManualVisibility.clear();
            }
        }
        return this;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public HologramData setPersistent(boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public String getLinkedNpcName() {
        return this.linkedNpcName;
    }

    public HologramData setLinkedNpcName(String linkedNpcName) {
        if (!Objects.equals(this.linkedNpcName, linkedNpcName)) {
            this.linkedNpcName = linkedNpcName;
            this.setHasChanges(true);
        }
        return this;
    }

    @Override
    public boolean read(ConfigurationSection section, String name) {
        String worldName = section.getString("location.world", "world");
        float x = (float)section.getDouble("location.x", 0.0);
        float y = (float)section.getDouble("location.y", 0.0);
        float z = (float)section.getDouble("location.z", 0.0);
        float yaw = (float)section.getDouble("location.yaw", 0.0);
        float pitch = (float)section.getDouble("location.pitch", 0.0);
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            FancyHologramsPlugin.get().getFancyLogger().warn("Could not load hologram '" + name + "', because the world '" + worldName + "' is not loaded", new Property[0]);
            return false;
        }
        this.location = new Location(world, (double)x, (double)y, (double)z, yaw, pitch);
        this.visibilityDistance = section.getInt("visibility_distance", -1);
        this.visibility = Optional.ofNullable(section.getString("visibility")).flatMap(Visibility::byString).orElseGet(() -> {
            boolean visibleByDefault = section.getBoolean("visible_by_default", true);
            return visibleByDefault ? Visibility.ALL : Visibility.PERMISSION_REQUIRED;
        });
        this.linkedNpcName = section.getString("linkedNpc");
        return true;
    }

    @Override
    public boolean write(ConfigurationSection section, String name) {
        section.set("type", (Object)this.type.name());
        section.set("location.world", (Object)this.location.getWorld().getName());
        section.set("location.x", (Object)this.location.x());
        section.set("location.y", (Object)this.location.y());
        section.set("location.z", (Object)this.location.z());
        section.set("location.yaw", (Object)Float.valueOf(this.location.getYaw()));
        section.set("location.pitch", (Object)Float.valueOf(this.location.getPitch()));
        section.set("visibility_distance", (Object)this.visibilityDistance);
        section.set("visibility", (Object)this.visibility.name());
        section.set("persistent", (Object)this.persistent);
        section.set("linkedNpc", (Object)this.linkedNpcName);
        return true;
    }

    public HologramData copy(String name) {
        return new HologramData(name, this.type, this.getLocation()).setVisibilityDistance(this.getVisibilityDistance()).setVisibility(this.getVisibility()).setPersistent(this.isPersistent()).setLinkedNpcName(this.getLinkedNpcName());
    }
}

