/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.commands.hologram;

import com.google.common.primitives.Doubles;
import de.oliver.fancyholograms.FancyHolograms;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.events.HologramUpdateEvent;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancyholograms.commands.HologramCMD;
import de.oliver.fancyholograms.commands.Subcommand;
import de.oliver.fancyholograms.util.Constants;
import de.oliver.fancylib.MessageHelper;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveHereCMD
implements Subcommand {
    public static boolean setLocation(Player player, Hologram hologram, Location location, boolean applyRotation) {
        if (!player.hasPermission("fancyholograms.hologram.edit.move_here")) {
            MessageHelper.error((CommandSender)player, "You don't have the required permission to move a hologram");
            return false;
        }
        HologramData copied = hologram.getData().copy(hologram.getName());
        Location newLocation = applyRotation ? location : new Location(location.getWorld(), location.x(), location.y(), location.z(), copied.getLocation().getYaw(), copied.getLocation().getPitch());
        copied.setLocation(newLocation);
        if (!HologramCMD.callModificationEvent(hologram, (CommandSender)player, copied, HologramUpdateEvent.HologramModification.POSITION)) {
            return false;
        }
        hologram.getData().setLocation(copied.getLocation());
        if (FancyHolograms.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHolograms.get().getHologramStorage().save(hologram);
        }
        MessageHelper.success((CommandSender)player, "Moved the hologram to %s/%s/%s %s\u00b0 %s\u00b0".formatted(Constants.COORDINATES_DECIMAL_FORMAT.format(newLocation.x()), Constants.COORDINATES_DECIMAL_FORMAT.format(newLocation.y()), Constants.COORDINATES_DECIMAL_FORMAT.format(newLocation.z()), Constants.COORDINATES_DECIMAL_FORMAT.format((newLocation.getYaw() + 180.0f) % 360.0f), Constants.COORDINATES_DECIMAL_FORMAT.format(newLocation.getPitch() % 360.0f)));
        return true;
    }

    @Nullable
    public static Double calculateCoordinate(@NotNull String text, @Nullable Location originLocation, @NotNull Location callerLocation, @NotNull Function<Location, Number> extractor) {
        Location target;
        Double number = Doubles.tryParse((String)StringUtils.stripStart((String)text, (String)"~"));
        Object object = text.startsWith("~~") ? callerLocation : (target = text.startsWith("~") ? originLocation : null);
        if (number == null) {
            return target == null ? null : Double.valueOf(extractor.apply(target).doubleValue());
        }
        if (target == null) {
            return number;
        }
        return number + extractor.apply(target).doubleValue();
    }

    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender sender, @Nullable Hologram hologram, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            MessageHelper.error(sender, "You must be a sender to use this command");
            return false;
        }
        Player player = (Player)sender;
        if (hologram.getData().getLinkedNpcName() != null) {
            MessageHelper.error((CommandSender)player, "This hologram is linked with an NPC");
            MessageHelper.error((CommandSender)player, "To unlink: /hologram edit " + hologram.getData().getName() + " unlinkWithNpc");
            return false;
        }
        Location location = player.getLocation();
        return MoveHereCMD.setLocation(player, hologram, location, false);
    }
}

