/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.commands.hologram;

import de.oliver.fancyholograms.FancyHolograms;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.events.HologramUpdateEvent;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancyholograms.commands.HologramCMD;
import de.oliver.fancyholograms.commands.Subcommand;
import de.oliver.fancylib.MessageHelper;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeeThroughCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        Boolean enabled;
        if (!player.hasPermission("fancyholograms.hologram.edit.see_trough")) {
            MessageHelper.error(player, "You don't have the required permission to edit a hologram");
            return false;
        }
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof TextHologramData)) {
            MessageHelper.error(player, "This command can only be used on text holograms");
            return false;
        }
        TextHologramData textData = (TextHologramData)hologramData;
        switch (args[3].toLowerCase(Locale.ROOT)) {
            case "true": {
                Boolean bl = true;
                break;
            }
            case "false": {
                Boolean bl = false;
                break;
            }
            default: {
                Boolean bl = enabled = null;
            }
        }
        if (enabled == null) {
            MessageHelper.error(player, "Could not parse see through flag");
            return false;
        }
        if (enabled.booleanValue() == textData.isSeeThrough()) {
            MessageHelper.warning(player, "This hologram already has see through " + (enabled != false ? "enabled" : "disabled"));
            return false;
        }
        TextHologramData copied = textData.copy(textData.getName());
        copied.setSeeThrough(enabled);
        if (!HologramCMD.callModificationEvent(hologram, player, copied, HologramUpdateEvent.HologramModification.SEE_THROUGH)) {
            return false;
        }
        if (enabled.booleanValue() == textData.isSeeThrough()) {
            MessageHelper.warning(player, "This hologram already has see through " + (enabled != false ? "enabled" : "disabled"));
            return false;
        }
        textData.setSeeThrough(copied.isSeeThrough());
        if (FancyHolograms.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHolograms.get().getHologramStorage().save(hologram);
        }
        MessageHelper.success(player, "Changed see through");
        return true;
    }
}

