/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.storage.converter;

import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.storage.converter.ConverterTarget;
import de.oliver.fancylib.MessageHelper;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HologramConversionSession {
    @NotNull
    private final ConverterTarget target;
    @NotNull
    private final CommandSender invoker;
    private final String[] arguments;

    public HologramConversionSession(@NotNull ConverterTarget target) {
        this(target, (CommandSender)Bukkit.getConsoleSender(), new String[0]);
    }

    public HologramConversionSession(@NotNull ConverterTarget target, @NotNull CommandSender invoker, @NotNull String[] arguments) {
        this.target = target;
        this.invoker = invoker;
        this.arguments = arguments;
    }

    @NotNull
    public ConverterTarget getTarget() {
        return this.target;
    }

    @NotNull
    public CommandSender getInvoker() {
        return this.invoker;
    }

    @NotNull
    public String[] getAdditionalArguments() {
        return this.arguments;
    }

    public void logUnsuccessfulConversion(@NotNull String oldHologram, @Nullable String message) {
        if (message != null) {
            MessageHelper.error(this.getInvoker(), String.format("There was an issue converting %s: %s", oldHologram, message));
        } else {
            MessageHelper.error(this.getInvoker(), String.format("There was an issue converting %s!", oldHologram));
        }
    }

    public void logSuccessfulConversion(@NotNull String oldHologram, @NotNull HologramData result) {
        this.logSuccessfulConversion(oldHologram, List.of(result));
    }

    public void logSuccessfulConversion(@NotNull String oldHologram, @NotNull List<HologramData> results) {
        MessageHelper.info(this.getInvoker(), String.format("Successfully converted %s to %s hologram(s).", oldHologram, results.size()));
        for (HologramData data : results) {
            MessageHelper.info(this.getInvoker(), String.format(" - %s type: %s", data.getName(), data.getType().name()));
        }
    }
}

