/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.jdb;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.oliver.jdb.JDocument;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JDB {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String FILE_EXTENSION = ".json";
    @NotNull
    private final String basePath;
    @NotNull
    private final File baseDirectory;

    public JDB(@NotNull String basePath) {
        this.basePath = basePath;
        this.baseDirectory = new File(basePath);
    }

    public <T> T get(@NotNull String path, @NotNull Class<T> clazz) throws IOException {
        File documentFile = new File(this.baseDirectory, this.createFilePath(path));
        if (!documentFile.exists()) {
            return null;
        }
        BufferedReader bufferedReader = Files.newBufferedReader(documentFile.toPath());
        return GSON.fromJson((Reader)bufferedReader, clazz);
    }

    public JDocument getDocument(@NotNull String path) throws IOException {
        File documentFile = new File(this.baseDirectory, this.createFilePath(path));
        if (!documentFile.exists()) {
            return null;
        }
        BufferedReader bufferedReader = Files.newBufferedReader(documentFile.toPath());
        Map data = GSON.fromJson((Reader)bufferedReader, Map.class);
        return new JDocument(data);
    }

    public <T> List<T> getAll(@NotNull String path, @NotNull Class<T> clazz) throws IOException {
        File directory = new File(this.baseDirectory, path);
        if (!directory.exists()) {
            return new ArrayList();
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return new ArrayList();
        }
        ArrayList<T> documents = new ArrayList<T>(files.length);
        for (File file : files) {
            documents.add(this.get(path + "/" + file.getName().replace(FILE_EXTENSION, ""), clazz));
        }
        return documents;
    }

    public <T> void set(@NotNull String path, @NotNull T value) throws IOException {
        File documentFile = new File(this.baseDirectory, this.createFilePath(path));
        if (!documentFile.exists()) {
            documentFile.getParentFile().mkdirs();
            documentFile.createNewFile();
        }
        String json = GSON.toJson(value);
        Files.write(documentFile.toPath(), json.getBytes(), new OpenOption[0]);
    }

    public void delete(@NotNull String path) {
        File file = new File(this.baseDirectory, path);
        if (file.isDirectory()) {
            this.deleteDirectory(file);
            return;
        }
        File documentFile = new File(this.baseDirectory, this.createFilePath(path));
        if (documentFile.exists()) {
            documentFile.delete();
        }
    }

    private String createFilePath(@NotNull String path) {
        return path + FILE_EXTENSION;
    }

    private void deleteDirectory(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.deleteDirectory(f);
                    continue;
                }
                f.delete();
            }
        }
        directory.delete();
    }
}

