/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.controller;

import com.fancyinnovations.fancyholograms.api.HologramController;
import com.fancyinnovations.fancyholograms.api.data.DisplayHologramData;
import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.oliver.fancynpcs.api.FancyNpcsPlugin;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class HologramControllerImpl
implements HologramController {
    @Override
    public void showHologramTo(@NotNull Hologram hologram, Player ... players) {
        for (Player player : players) {
            boolean isVisible = hologram.isViewer(player);
            boolean shouldSee = this.shouldSeeHologram(hologram, player);
            if (isVisible || !shouldSee) continue;
            hologram.spawnTo(player);
            hologram.getData().getTraitTrait().onSpawn(player);
        }
    }

    @Override
    public void hideHologramFrom(@NotNull Hologram hologram, Player ... players) {
        for (Player player : players) {
            boolean isVisible = hologram.isViewer(player);
            boolean shouldSee = this.shouldSeeHologram(hologram, player);
            if (!isVisible || shouldSee) continue;
            hologram.despawnFrom(player);
            hologram.getData().getTraitTrait().onDespawn(player);
        }
    }

    @Override
    @ApiStatus.Internal
    public void updateHologramData(@NotNull Hologram hologram, Player ... players) {
        for (Player player : players) {
            boolean isVisible = hologram.isViewer(player);
            boolean shouldSee = this.shouldSeeHologram(hologram, player);
            if (!isVisible || !shouldSee) continue;
            hologram.updateFor(player);
            hologram.getData().getTraitTrait().onUpdate(player);
        }
    }

    @Override
    public boolean shouldSeeHologram(@NotNull Hologram hologram, @NotNull Player player) {
        if (!this.meetsVisibilityConditions(hologram, player)) {
            return false;
        }
        return this.isWithinVisibilityDistance(hologram, player);
    }

    @Override
    public void refreshHologram(@NotNull Hologram hologram, Player ... players) {
        this.hideHologramFrom(hologram, players);
        this.showHologramTo(hologram, players);
    }

    private boolean meetsVisibilityConditions(@NotNull Hologram hologram, @NotNull Player player) {
        return hologram.getData().getVisibility().canSee(player, hologram);
    }

    private boolean isWithinVisibilityDistance(@NotNull Hologram hologram, @NotNull Player player) {
        if (!hologram.getData().getWorldName().equals(player.getWorld().getName())) {
            return false;
        }
        Location location = hologram.getData().getLocation();
        if (location.getWorld() == null) {
            return false;
        }
        int visibilityDistance = hologram.getData().getVisibilityDistance();
        double distanceSquared = location.distanceSquared(player.getLocation());
        return distanceSquared <= (double)(visibilityDistance * visibilityDistance);
    }

    public void initRefreshTask() {
        FancyHologramsPlugin.get().getHologramThread().scheduleWithFixedDelay(() -> {
            for (Hologram hologram : FancyHologramsPlugin.get().getRegistry().getAll()) {
                this.refreshHologram(hologram, Bukkit.getOnlinePlayers().toArray(new Player[0]));
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    public void initUpdateTask() {
        Cache updateTimes = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(5L)).build();
        FancyHologramsPlugin.get().getHologramThread().scheduleWithFixedDelay(() -> {
            long time = System.currentTimeMillis();
            for (Hologram hologram : FancyHologramsPlugin.get().getRegistry().getAll()) {
                HologramData data = hologram.getData();
                if (!data.hasChanges()) continue;
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    hologram.updateFor(onlinePlayer);
                }
                data.setHasChanges(false);
                if (!(data instanceof TextHologramData)) continue;
                updateTimes.put((Object)hologram.getData().getName(), (Object)time);
            }
        }, 50L, 1000L, TimeUnit.MILLISECONDS);
        FancyHologramsPlugin.get().getHologramThread().scheduleWithFixedDelay(() -> {
            long time = System.currentTimeMillis();
            for (Hologram hologram : FancyHologramsPlugin.get().getRegistry().getAll()) {
                Long lastUpdate;
                TextHologramData textData;
                int interval;
                HologramData patt0$temp = hologram.getData();
                if (!(patt0$temp instanceof TextHologramData) || (interval = (textData = (TextHologramData)patt0$temp).getTextUpdateInterval()) < 1 || (lastUpdate = (Long)updateTimes.asMap().get(textData.getName())) != null && time < lastUpdate + (long)interval || lastUpdate != null && time <= lastUpdate + (long)interval) continue;
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    hologram.updateFor(onlinePlayer);
                }
                updateTimes.put((Object)textData.getName(), (Object)time);
            }
        }, 50L, 50L, TimeUnit.MILLISECONDS);
    }

    public void syncHologramWithNpc(@NotNull Hologram hologram) {
        String linkedNpcName = hologram.getData().getLinkedNpcName();
        if (linkedNpcName == null) {
            return;
        }
        Npc npc = FancyNpcsPlugin.get().getNpcManager().getNpc(linkedNpcName);
        if (npc == null) {
            return;
        }
        npc.getData().setDisplayName("<empty>");
        npc.getData().setShowInTab(false);
        npc.updateForAll();
        float npcScale = npc.getData().getScale();
        HologramData hologramData = hologram.getData();
        if (hologramData instanceof DisplayHologramData) {
            DisplayHologramData displayData = (DisplayHologramData)hologramData;
            displayData.setScale(new Vector3f(npcScale));
        }
        Location location = npc.getData().getLocation().clone().add(0.0, (double)(npc.getEyeHeight() * npcScale) + 0.5 * (double)npcScale, 0.0);
        for (Map.Entry entry : npc.getData().getAttributes().entrySet()) {
            NpcAttribute attribute = (NpcAttribute)entry.getKey();
            String value = (String)entry.getValue();
            if (!attribute.getName().equalsIgnoreCase("pose") || !value.equalsIgnoreCase("sitting")) continue;
            location.subtract(0.0, 0.5 * (double)npcScale, 0.0);
        }
        hologram.getData().setLocation(location);
    }
}

