/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.registry;

import com.fancyinnovations.fancyholograms.api.HologramRegistry;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class HologramRegistryImpl
implements HologramRegistry {
    private final Map<String, Hologram> holograms = new ConcurrentHashMap<String, Hologram>();

    @Override
    public boolean register(Hologram hologram) {
        FancyHologramsPlugin.get().getController().refreshHologram(hologram, Bukkit.getOnlinePlayers());
        boolean registered = this.holograms.putIfAbsent(hologram.getData().getName(), hologram) != null;
        hologram.getData().getTraitTrait().onRegister();
        return registered;
    }

    @Override
    public boolean unregister(Hologram hologram) {
        boolean removed = this.holograms.remove(hologram.getData().getName(), hologram);
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            hologram.despawnFrom(onlinePlayer);
        }
        FancyHologramsPlugin.get().getStorage().delete(hologram.getData());
        hologram.getData().getTraitTrait().onUnregister();
        return removed;
    }

    @Override
    public boolean contains(String name) {
        return this.holograms.containsKey(name);
    }

    @Override
    public Optional<Hologram> get(String name) {
        return Optional.ofNullable(this.holograms.get(name));
    }

    @Override
    public Hologram mustGet(String name) {
        if (!this.contains(name)) {
            throw new IllegalArgumentException("Hologram with name " + name + " does not exist!");
        }
        return this.holograms.get(name);
    }

    @Override
    public Collection<Hologram> getAll() {
        return Collections.unmodifiableCollection(this.holograms.values());
    }

    @Override
    public Collection<Hologram> getAllPersistent() {
        return this.getAll().stream().filter(hologram -> hologram.getData().isPersistent()).toList();
    }

    @Override
    public void clear() {
        for (Hologram hologram : this.holograms.values()) {
            hologram.getData().getTraitTrait().onUnregister();
        }
        this.holograms.clear();
    }
}

