/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.storage.json;

import com.fancyinnovations.fancyholograms.api.FancyHolograms;
import com.fancyinnovations.fancyholograms.api.data.BlockHologramData;
import com.fancyinnovations.fancyholograms.api.data.DisplayHologramData;
import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.ItemHologramData;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.hologram.HologramType;
import com.fancyinnovations.fancyholograms.api.trait.HologramTrait;
import com.fancyinnovations.fancyholograms.api.trait.HologramTraitRegistry;
import com.fancyinnovations.fancyholograms.storage.json.model.JsonBlockHologramData;
import com.fancyinnovations.fancyholograms.storage.json.model.JsonBrightness;
import com.fancyinnovations.fancyholograms.storage.json.model.JsonDataUnion;
import com.fancyinnovations.fancyholograms.storage.json.model.JsonDisplayHologramData;
import com.fancyinnovations.fancyholograms.storage.json.model.JsonHologramData;
import com.fancyinnovations.fancyholograms.storage.json.model.JsonItemHologramData;
import com.fancyinnovations.fancyholograms.storage.json.model.JsonLocation;
import com.fancyinnovations.fancyholograms.storage.json.model.JsonTextHologramData;
import com.fancyinnovations.fancyholograms.storage.json.model.JsonVec3f;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import java.util.Base64;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Display;
import org.bukkit.inventory.ItemStack;
import org.joml.Vector3f;

public class JsonAdapter {
    public static JsonHologramData hologramDataToJson(HologramData data) {
        return new JsonHologramData(data.getName(), data.getType(), new JsonLocation(data.getWorldName(), data.getLocation().getX(), data.getLocation().getY(), data.getLocation().getZ(), Float.valueOf(data.getLocation().getYaw()), Float.valueOf(data.getLocation().getPitch())), data.getWorldName(), data.getVisibilityDistance(), data.getVisibility(), data.getLinkedNpcName(), data.getTraitTrait().getTraits().stream().map(HologramTrait::getName).toList());
    }

    public static JsonDisplayHologramData displayHologramDataToJson(DisplayHologramData data) {
        return new JsonDisplayHologramData(new JsonVec3f(Float.valueOf(data.getScale().x()), Float.valueOf(data.getScale().y()), Float.valueOf(data.getScale().z())), new JsonVec3f(Float.valueOf(data.getTranslation().x()), Float.valueOf(data.getTranslation().y()), Float.valueOf(data.getTranslation().z())), Float.valueOf(data.getShadowRadius()), Float.valueOf(data.getShadowStrength()), data.getBrightness() == null ? null : new JsonBrightness(data.getBrightness().getBlockLight(), data.getBrightness().getSkyLight()), data.getBillboard());
    }

    public static JsonTextHologramData textHologramDataToJson(TextHologramData data) {
        return new JsonTextHologramData(data.getText(), data.hasTextShadow(), data.isSeeThrough(), data.getTextAlignment(), data.getTextUpdateInterval(), (String)(data.getBackground() == null ? "" : "#" + Integer.toHexString(data.getBackground().asARGB())));
    }

    public static JsonBlockHologramData blockHologramDataToJson(BlockHologramData data) {
        return new JsonBlockHologramData(data.getBlock().name());
    }

    public static JsonItemHologramData itemHologramDataToJson(ItemHologramData data) {
        return new JsonItemHologramData(Base64.getEncoder().encodeToString(data.getItemStack().serializeAsBytes()));
    }

    public static JsonDataUnion toUnion(TextHologramData data) {
        JsonHologramData hologramData = JsonAdapter.hologramDataToJson(data);
        JsonDisplayHologramData displayHologramData = JsonAdapter.displayHologramDataToJson(data);
        JsonTextHologramData textHologramData = JsonAdapter.textHologramDataToJson(data);
        return new JsonDataUnion(hologramData, displayHologramData, textHologramData, null, null);
    }

    public static JsonDataUnion toUnion(ItemHologramData data) {
        JsonHologramData hologramData = JsonAdapter.hologramDataToJson(data);
        JsonDisplayHologramData displayHologramData = JsonAdapter.displayHologramDataToJson(data);
        JsonItemHologramData itemHologramData = JsonAdapter.itemHologramDataToJson(data);
        return new JsonDataUnion(hologramData, displayHologramData, null, itemHologramData, null);
    }

    public static JsonDataUnion toUnion(BlockHologramData data) {
        JsonHologramData hologramData = JsonAdapter.hologramDataToJson(data);
        JsonDisplayHologramData displayHologramData = JsonAdapter.displayHologramDataToJson(data);
        JsonBlockHologramData blockHologramData = JsonAdapter.blockHologramDataToJson(data);
        return new JsonDataUnion(hologramData, displayHologramData, null, null, blockHologramData);
    }

    public static HologramData fromJson(JsonDataUnion data) {
        if (!data.hologram_data().worldName().equals(data.hologram_data().location().world())) {
            throw new IllegalArgumentException("World name in hologram data does not match location world");
        }
        Location loc = new Location(Bukkit.getWorld((String)data.hologram_data().worldName()), data.hologram_data().location().x().doubleValue(), data.hologram_data().location().y().doubleValue(), data.hologram_data().location().z().doubleValue(), data.hologram_data().location().yaw().floatValue(), data.hologram_data().location().pitch().floatValue());
        Vector3f scale = new Vector3f(data.display_data().scale().x().floatValue(), data.display_data().scale().y().floatValue(), data.display_data().scale().z().floatValue());
        Vector3f translation = new Vector3f(data.display_data().translation().x().floatValue(), data.display_data().translation().y().floatValue(), data.display_data().translation().z().floatValue());
        Display.Brightness brightness = null;
        if (data.display_data().brightness() != null && data.display_data().brightness().sky_light() != null) {
            brightness = new Display.Brightness(data.display_data().brightness().block_light().intValue(), data.display_data().brightness().sky_light().intValue());
        }
        HologramData hologramData = switch (data.hologram_data().type()) {
            default -> throw new MatchException(null, null);
            case HologramType.TEXT -> new TextHologramData(data.hologram_data().name(), loc).setText(data.text_data().text()).setBackground(data.text_data().background_color()).setTextAlignment(data.text_data().text_alignment()).setTextShadow(data.text_data().text_shadow()).setSeeThrough(data.text_data().see_through()).setTextUpdateInterval(data.text_data().text_update_interval()).setBillboard(data.display_data().billboard()).setScale(scale).setTranslation(translation).setBrightness(brightness).setShadowRadius(data.display_data().shadow_radius().floatValue()).setShadowStrength(data.display_data().shadow_strength().floatValue()).setWorldName(data.hologram_data().worldName()).setVisibilityDistance(data.hologram_data().visibilityDistance()).setVisibility(data.hologram_data().visibility()).setLinkedNpcName(data.hologram_data().linkedNpcName());
            case HologramType.ITEM -> new ItemHologramData(data.hologram_data().name(), loc).setItemStack(ItemStack.deserializeBytes((byte[])Base64.getDecoder().decode(data.item_data().item()))).setBillboard(data.display_data().billboard()).setScale(scale).setTranslation(translation).setBrightness(brightness).setShadowRadius(data.display_data().shadow_radius().floatValue()).setShadowStrength(data.display_data().shadow_strength().floatValue()).setWorldName(data.hologram_data().worldName()).setVisibilityDistance(data.hologram_data().visibilityDistance()).setVisibility(data.hologram_data().visibility()).setLinkedNpcName(data.hologram_data().linkedNpcName());
            case HologramType.BLOCK -> new BlockHologramData(data.hologram_data().name(), loc).setBlock(Material.getMaterial((String)data.block_data().block_material())).setBillboard(data.display_data().billboard()).setScale(scale).setTranslation(translation).setBrightness(brightness).setShadowRadius(data.display_data().shadow_radius().floatValue()).setShadowStrength(data.display_data().shadow_strength().floatValue()).setWorldName(data.hologram_data().worldName()).setVisibilityDistance(data.hologram_data().visibilityDistance()).setVisibility(data.hologram_data().visibility()).setLinkedNpcName(data.hologram_data().linkedNpcName());
        };
        for (String traitName : data.hologram_data().traits()) {
            HologramTraitRegistry.TraitInfo traitInfo = FancyHolograms.get().getTraitRegistry().getTrait(traitName);
            if (traitInfo == null) {
                FancyHolograms.get().getFancyLogger().warn("Trait " + traitName + " is not registered", new Property[0]);
                continue;
            }
            try {
                HologramTrait trait = traitInfo.clazz().getConstructor(new Class[0]).newInstance(new Object[0]);
                hologramData.getTraitTrait().addTrait(trait);
            }
            catch (Exception e) {
                FancyHolograms.get().getFancyLogger().error("Failed to instantiate trait " + traitName, ThrowableProperty.of(e));
            }
        }
        return hologramData;
    }
}

