/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.tests.mocks;

import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class HologramMock
extends Hologram {
    private final Runnable spawnToCallback;
    private final Runnable despawnFromCallback;
    private final Runnable updateForCallback;

    public HologramMock(@NotNull HologramData data, Runnable spawnToCallback, Runnable despawnFromCallback, Runnable updateForCallback) {
        super(data);
        this.spawnToCallback = spawnToCallback;
        this.despawnFromCallback = despawnFromCallback;
        this.updateForCallback = updateForCallback;
    }

    @Override
    public void spawnTo(@NotNull Player player) {
        this.spawnToCallback.run();
        this.viewers.add(player.getUniqueId());
    }

    @Override
    public void despawnFrom(@NotNull Player player) {
        this.despawnFromCallback.run();
        this.viewers.remove(player.getUniqueId());
    }

    @Override
    public void updateFor(@NotNull Player player) {
        this.updateForCallback.run();
    }
}

