/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyanalytics.logger;

import de.oliver.fancyanalytics.logger.FancyLogger;
import de.oliver.fancyanalytics.logger.LogEntry;
import de.oliver.fancyanalytics.logger.LogLevel;
import de.oliver.fancyanalytics.logger.appender.Appender;
import de.oliver.fancyanalytics.logger.middleware.Middleware;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import java.util.HashMap;
import java.util.List;

public class ExtendedFancyLogger
extends FancyLogger {
    public ExtendedFancyLogger(String name) {
        super(name);
    }

    public ExtendedFancyLogger(String name, LogLevel currentLevel, List<Appender> appenders, List<Middleware> middlewares) {
        super(name, currentLevel, appenders, middlewares);
    }

    public void log(LogLevel logLevel, String message, Property<?> ... properties) {
        Throwable throwable = null;
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Property<?> property : properties) {
            if (property instanceof ThrowableProperty) {
                ThrowableProperty tp = (ThrowableProperty)property;
                throwable = (Throwable)tp.getValue();
                continue;
            }
            props.put(property.getKey(), property.getValue());
        }
        long threadId = Thread.currentThread().getId();
        String threadName = Thread.currentThread().getName();
        props.put("thread_id", threadId);
        props.put("thread_name", threadName);
        if (throwable != null) {
            props.put("throwable", throwable);
        }
        this.log(logLevel, new LogEntry(this.name, logLevel, message, System.currentTimeMillis(), props), this.defaultAppenders);
    }

    public void debug(String message, Property<?> ... properties) {
        this.log(LogLevel.DEBUG, message, properties);
    }

    public void info(String message, Property<?> ... properties) {
        this.log(LogLevel.INFO, message, properties);
    }

    public void warn(String message, Property<?> ... properties) {
        this.log(LogLevel.WARN, message, properties);
    }

    public void error(String message, Property<?> ... properties) {
        this.log(LogLevel.ERROR, message, properties);
    }
}

