/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.chatcolorhandler.parsers.custom;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import org.jetbrains.annotations.NotNull;
import org.lushplugins.chatcolorhandler.messengers.MiniMessageMessenger;
import org.lushplugins.chatcolorhandler.parsers.Parser;
import org.lushplugins.chatcolorhandler.parsers.Resolver;

public class MiniMessageColorParser
implements Resolver {
    public static final MiniMessageColorParser INSTANCE = new MiniMessageColorParser();
    private static final TagResolver BASIC_COLORS = TagResolver.builder().resolvers(MiniMessageColorParser.tagResolvers()).build();

    private MiniMessageColorParser() {
    }

    @Override
    public String getType() {
        return "color";
    }

    @Override
    public String parseString(@NotNull String string, @NotNull Parser.OutputType outputType) {
        return switch (outputType) {
            default -> throw new MatchException(null, null);
            case Parser.OutputType.SPIGOT -> {
                string = string.replace('\u00a7', '&');
                yield MiniMessageMessenger.LEGACY_COMPONENT_SERIALIZER.serialize(MiniMessageMessenger.MINI_MESSAGE.deserialize(string, BASIC_COLORS));
            }
            case Parser.OutputType.MINI_MESSAGE -> string;
        };
    }

    @Override
    @NotNull
    public TagResolver getResolver() {
        return BASIC_COLORS;
    }

    private static List<TagResolver> tagResolvers() {
        ArrayList<TagResolver> resolvers = new ArrayList<TagResolver>();
        try {
            resolvers.add(StandardTags.color());
            resolvers.add(StandardTags.decorations());
            resolvers.add(StandardTags.gradient());
            resolvers.add(StandardTags.rainbow());
            resolvers.add(StandardTags.reset());
            resolvers.add(StandardTags.transition());
            resolvers.add(StandardTags.pride());
            resolvers.add(StandardTags.shadowColor());
            resolvers.add(StandardTags.sequentialHead());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return resolvers;
    }
}

