/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.api.hologram;

import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.libs.chatcolorhandler.ModernChatColorHandler;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.Color;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Hologram {
    public static final int LINE_WIDTH = 1000;
    public static final Color TRANSPARENT = Color.fromARGB((int)0);
    protected static final int MINIMUM_PROTOCOL_VERSION = 762;
    @NotNull
    protected final HologramData data;
    @NotNull
    protected final Set<UUID> viewers;

    protected Hologram(@NotNull HologramData data) {
        this.data = data;
        this.viewers = new HashSet<UUID>();
        this.data.getTraitTrait().attachHologram(this);
        this.data.setOnModify(this.data.getTraitTrait()::onModify);
    }

    @ApiStatus.Internal
    public abstract void spawnTo(@NotNull Player var1);

    @ApiStatus.Internal
    public abstract void despawnFrom(@NotNull Player var1);

    @ApiStatus.Internal
    public abstract void updateFor(@NotNull Player var1);

    @NotNull
    public final Set<UUID> getViewers() {
        return Sets.newHashSet(this.viewers);
    }

    @ApiStatus.Internal
    public void setViewers(@NotNull Set<UUID> viewers) {
        this.viewers.clear();
        this.viewers.addAll(viewers);
    }

    @ApiStatus.Internal
    public void removeViewer(@NotNull UUID viewer) {
        this.viewers.remove(viewer);
    }

    public final boolean isViewer(@NotNull Player player) {
        return this.isViewer(player.getUniqueId());
    }

    public final boolean isViewer(@NotNull UUID player) {
        return this.viewers.contains(player);
    }

    @NotNull
    public final HologramData getData() {
        return this.data;
    }

    @ApiStatus.Experimental
    @NotNull
    public final <T extends HologramData> T getData(@NotNull Class<T> clazz) {
        return (T)((HologramData)clazz.cast(this.data));
    }

    @ApiStatus.Experimental
    @Nullable
    public final <T extends HologramData> T getDataNullable(@NotNull Class<T> clazz) {
        try {
            return (T)((HologramData)clazz.cast(this.data));
        }
        catch (ClassCastException ignored) {
            return null;
        }
    }

    @ApiStatus.Experimental
    public final <T extends HologramData> void consumeData(@NotNull Class<T> clazz, @NotNull Consumer<T> consumer) {
        T data = this.getDataNullable(clazz);
        if (data != null) {
            consumer.accept(data);
        }
    }

    public final Component getShownText(@Nullable Player player) {
        HologramData hologramData = this.getData();
        if (!(hologramData instanceof TextHologramData)) {
            return null;
        }
        TextHologramData textData = (TextHologramData)hologramData;
        String text = String.join((CharSequence)"\n", textData.getText());
        return ModernChatColorHandler.translate(text, player);
    }
}

