/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.api.data;

import com.fancyinnovations.fancyholograms.api.data.DisplayHologramData;
import com.fancyinnovations.fancyholograms.api.hologram.HologramType;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;

public class ItemHologramData
extends DisplayHologramData {
    public static final ItemStack DEFAULT_ITEM = new ItemStack(Material.APPLE);
    private ItemStack item = DEFAULT_ITEM;

    public ItemHologramData(String name, Location location) {
        super(name, HologramType.ITEM, location);
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public ItemHologramData setItemStack(ItemStack item) {
        if (!Objects.equals(this.item, item)) {
            this.item = item;
            this.setHasChanges(true);
        }
        return this;
    }

    @Override
    @ApiStatus.Internal
    public boolean read(ConfigurationSection section, String name) {
        super.read(section, name);
        this.item = section.getItemStack("item", DEFAULT_ITEM);
        return true;
    }

    @Override
    @ApiStatus.Internal
    public boolean write(ConfigurationSection section, String name) {
        super.write(section, name);
        section.set("item", (Object)this.item);
        return true;
    }

    @Override
    public ItemHologramData copy(String name) {
        ItemHologramData itemHologramData = new ItemHologramData(name, this.getLocation());
        itemHologramData.setItemStack(this.getItemStack()).setScale(this.getScale()).setShadowRadius(this.getShadowRadius()).setShadowStrength(this.getShadowStrength()).setBillboard(this.getBillboard()).setTranslation(this.getTranslation()).setBrightness(this.getBrightness()).setVisibilityDistance(this.getVisibilityDistance()).setVisibility(this.getVisibility()).setPersistent(this.isPersistent()).setLinkedNpcName(this.getLinkedNpcName());
        return itemHologramData;
    }
}

