/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands.hologram;

import com.fancyinnovations.fancyholograms.api.data.DisplayHologramData;
import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.events.HologramUpdateEvent;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.commands.HologramCMD;
import com.fancyinnovations.fancyholograms.commands.Subcommand;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import com.google.common.primitives.Floats;
import de.oliver.fancylib.MessageHelper;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ScaleCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        Float scaleZ;
        if (!player.hasPermission("fancyholograms.hologram.edit.scale")) {
            MessageHelper.error(player, "You don't have the required permission to change the scale of a hologram");
            return false;
        }
        Float scaleX = Floats.tryParse((String)args[3]);
        Float scaleY = args.length >= 6 ? Floats.tryParse((String)args[4]) : scaleX;
        Float f = scaleZ = args.length >= 6 ? Floats.tryParse((String)args[5]) : scaleX;
        if (scaleX == null || scaleY == null || scaleZ == null) {
            MessageHelper.error(player, "Could not parse scale");
            return false;
        }
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof DisplayHologramData)) {
            MessageHelper.error(player, "This command can only be used on display holograms");
            return false;
        }
        DisplayHologramData displayData = (DisplayHologramData)hologramData;
        if (Float.compare(scaleX.floatValue(), displayData.getScale().x()) == 0 && Float.compare(scaleY.floatValue(), displayData.getScale().y()) == 0 && Float.compare(scaleZ.floatValue(), displayData.getScale().z()) == 0) {
            MessageHelper.warning(player, "This hologram is already at this scale");
            return false;
        }
        DisplayHologramData copied = displayData.copy(displayData.getName());
        copied.setScale(new Vector3f(scaleX.floatValue(), scaleY.floatValue(), scaleZ.floatValue()));
        if (!HologramCMD.callModificationEvent(hologram, player, copied, HologramUpdateEvent.HologramModification.SCALE)) {
            return false;
        }
        if (Float.compare(copied.getScale().x(), displayData.getScale().x()) == 0 && Float.compare(copied.getScale().y(), displayData.getScale().y()) == 0 && Float.compare(copied.getScale().z(), displayData.getScale().z()) == 0) {
            MessageHelper.warning(player, "This hologram is already at this scale");
            return false;
        }
        displayData.setScale(new Vector3f(copied.getScale().x(), copied.getScale().y(), copied.getScale().z()));
        if (FancyHologramsPlugin.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHologramsPlugin.get().getStorage().save(hologram.getData());
        }
        MessageHelper.success(player, "Changed scale to " + scaleX + ", " + scaleY + ", " + scaleZ);
        return true;
    }
}

