/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.storage;

import com.fancyinnovations.fancyholograms.api.data.BlockHologramData;
import com.fancyinnovations.fancyholograms.api.data.DisplayHologramData;
import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.ItemHologramData;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.hologram.HologramType;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import com.fancyinnovations.fancyholograms.storage.HologramStorage;
import de.oliver.fancyanalytics.logger.properties.Property;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlHologramStorage
implements HologramStorage {
    public static final File HOLOGRAMS_CONFIG_FILE = new File("plugins/FancyHolograms/holograms.yml");
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveBatch(Collection<HologramData> holograms) {
        lock.readLock().lock();
        boolean success = false;
        YamlConfiguration config = null;
        try {
            config = YamlConfiguration.loadConfiguration((File)HOLOGRAMS_CONFIG_FILE);
            for (HologramData hologram : holograms) {
                this.writeHologram(config, hologram);
            }
            success = true;
        }
        finally {
            lock.readLock().unlock();
            if (success) {
                this.saveConfig(config);
            }
        }
        FancyHologramsPlugin.get().getFancyLogger().debug("Saved " + holograms.size() + " holograms to file", new Property[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(HologramData hologram) {
        lock.readLock().lock();
        boolean success = false;
        YamlConfiguration config = null;
        try {
            config = YamlConfiguration.loadConfiguration((File)HOLOGRAMS_CONFIG_FILE);
            this.writeHologram(config, hologram);
            success = true;
        }
        finally {
            lock.readLock().unlock();
            if (success) {
                this.saveConfig(config);
            }
        }
        FancyHologramsPlugin.get().getFancyLogger().debug("Saved hologram " + hologram.getName() + " to file", new Property[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(HologramData hologram) {
        lock.readLock().lock();
        boolean success = false;
        YamlConfiguration config = null;
        try {
            config = YamlConfiguration.loadConfiguration((File)HOLOGRAMS_CONFIG_FILE);
            config.set("holograms." + hologram.getName(), null);
            success = true;
        }
        finally {
            lock.readLock().unlock();
            if (success) {
                this.saveConfig(config);
            }
        }
        FancyHologramsPlugin.get().getFancyLogger().debug("Deleted hologram " + hologram.getName() + " from file", new Property[0]);
    }

    @Override
    public Collection<HologramData> loadAll() {
        List<HologramData> holograms = this.readHolograms(HOLOGRAMS_CONFIG_FILE, null);
        FancyHologramsPlugin.get().getFancyLogger().debug("Loaded " + holograms.size() + " holograms from file", new Property[0]);
        return holograms;
    }

    @Override
    public Collection<HologramData> loadAll(String world) {
        List<HologramData> holograms = this.readHolograms(HOLOGRAMS_CONFIG_FILE, world);
        FancyHologramsPlugin.get().getFancyLogger().debug("Loaded " + holograms.size() + " holograms from file (world=" + world + ")", new Property[0]);
        return holograms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HologramData> readHolograms(@NotNull File configFile, @Nullable String world) {
        lock.readLock().lock();
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            if (!config.isConfigurationSection("holograms")) {
                FancyHologramsPlugin.get().getFancyLogger().warn("No holograms section found in config", new Property[0]);
                ArrayList<HologramData> arrayList = new ArrayList<HologramData>(0);
                return arrayList;
            }
            int configVersion = config.getInt("version", 1);
            if (configVersion != 2) {
                FancyHologramsPlugin.get().getFancyLogger().warn("Config version is not 2, skipping loading holograms", new Property[0]);
                FancyHologramsPlugin.get().getFancyLogger().warn("Old config version detected, skipping loading holograms", new Property[0]);
                ArrayList<HologramData> arrayList = new ArrayList<HologramData>(0);
                return arrayList;
            }
            ArrayList<HologramData> holograms = new ArrayList<HologramData>();
            ConfigurationSection hologramsSection = config.getConfigurationSection("holograms");
            for (String name : hologramsSection.getKeys(false)) {
                ConfigurationSection holoSection = hologramsSection.getConfigurationSection(name);
                if (holoSection == null) {
                    FancyHologramsPlugin.get().getFancyLogger().warn("Could not load hologram section in config", new Property[0]);
                    continue;
                }
                if (world != null && !holoSection.getString("location.world").equals(world)) continue;
                String typeName = holoSection.getString("type");
                if (typeName == null) {
                    FancyHologramsPlugin.get().getFancyLogger().warn("HologramType was not saved", new Property[0]);
                    continue;
                }
                HologramType type = HologramType.getByName(typeName);
                if (type == null) {
                    FancyHologramsPlugin.get().getFancyLogger().warn("Could not parse HologramType", new Property[0]);
                    continue;
                }
                HologramData displayData = null;
                switch (type) {
                    case TEXT: {
                        displayData = new TextHologramData(name, new Location(null, 0.0, 0.0, 0.0));
                        break;
                    }
                    case ITEM: {
                        displayData = new ItemHologramData(name, new Location(null, 0.0, 0.0, 0.0));
                        break;
                    }
                    case BLOCK: {
                        displayData = new BlockHologramData(name, new Location(null, 0.0, 0.0, 0.0));
                    }
                }
                displayData.setWorldName(holoSection.getString("location.world"));
                if (!((DisplayHologramData)displayData).read(holoSection, name)) {
                    FancyHologramsPlugin.get().getFancyLogger().warn("Could not read hologram data - skipping hologram", new Property[0]);
                    continue;
                }
                holograms.add(displayData);
            }
            FancyHologramsPlugin.get().getFancyLogger().debug("Loaded " + holograms.size() + " holograms from file", new Property[0]);
            ArrayList<HologramData> arrayList = holograms;
            return arrayList;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    private void writeHologram(YamlConfiguration config, HologramData hologram) {
        String holoName;
        @NotNull ConfigurationSection section = !config.isConfigurationSection("holograms") ? config.createSection("holograms") : Objects.requireNonNull(config.getConfigurationSection("holograms"));
        ConfigurationSection holoSection = section.getConfigurationSection(holoName = hologram.getName());
        if (holoSection == null) {
            holoSection = section.createSection(holoName);
        }
        hologram.write(holoSection, holoName);
        FancyHologramsPlugin.get().getFancyLogger().debug("Wrote hologram " + holoName + " to config", new Property[0]);
    }

    private void saveConfig(YamlConfiguration config) {
        config.set("version", (Object)2);
        config.setInlineComments("version", List.of("DO NOT CHANGE"));
        FancyHologramsPlugin.get().getStorageThread().execute(() -> {
            lock.writeLock().lock();
            try {
                config.save(HOLOGRAMS_CONFIG_FILE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                lock.writeLock().unlock();
            }
            if (!FancyHologramsPlugin.canGet()) {
                return;
            }
            FancyHologramsPlugin.get().getFancyLogger().debug("Saved config to file", new Property[0]);
        });
    }
}

