/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.trait.builtin;

import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.trait.HologramTrait;
import com.fancyinnovations.fancyholograms.api.trait.HologramTraitClass;
import com.fancyinnovations.fancyholograms.util.PluginUtils;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import de.oliver.fancynpcs.api.FancyNpcsPlugin;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.api.NpcData;
import de.oliver.fancynpcs.api.actions.ActionTrigger;
import de.oliver.fancynpcs.api.actions.NpcAction;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;

@HologramTraitClass(traitName="interaction_trait")
@ApiStatus.Experimental
public class InteractionTrait
extends HologramTrait {
    private static final FancyNpcsPlugin FN = FancyNpcsPlugin.get();
    private Configuration config;
    private Npc hitbox;

    public InteractionTrait() {
        if (!PluginUtils.isFancyNpcsEnabled()) {
            throw new IllegalStateException("FancyNpcs is not enabled. Please enable it to use InteractionTrait.");
        }
    }

    @Override
    public void onAttach() {
        this.load();
        this.updateHitbox();
    }

    @Override
    public void onSpawn(Player player) {
        this.updateHitbox();
    }

    @Override
    public void onDespawn(Player player) {
        this.updateHitbox();
    }

    @Override
    public void onModify() {
        this.updateHitbox();
    }

    @Override
    public void onUnregister() {
        if (this.hitbox != null) {
            this.hitbox.removeForAll();
            FN.getNpcManager().removeNpc(this.hitbox);
            this.hitbox = null;
        }
    }

    @Override
    public void save() {
        try {
            this.storage.set(this.hologram.getData().getName(), this.config);
        }
        catch (Exception e) {
            this.logger.error("Failed to save configuration for InteractionTrait", ThrowableProperty.of(e));
        }
    }

    @Override
    public void load() {
        try {
            this.config = this.storage.get(this.hologram.getData().getName(), Configuration.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to load configuration for InteractionTrait", ThrowableProperty.of(e));
        }
        if (this.config == null) {
            this.config = new Configuration(List.of(new ActionConfig("message", "Hi, you just clicked a hologram!")));
            this.save();
        }
    }

    private void updateHitbox() {
        if (FN.getNpcManager().getNpc("hologram_hitbox_for_" + this.hologram.getData().getName()) == null) {
            this.hitbox = (Npc)FN.getNpcAdapter().apply(new NpcData("hologram_hitbox_for_" + this.hologram.getData().getName(), UUID.randomUUID(), this.hologram.getData().getLocation()));
            this.hitbox.setSaveToFile(false);
            this.hitbox.getData().setType(EntityType.INTERACTION);
            this.hitbox.getData().setDisplayName("<empty>");
            ArrayList<NpcAction.NpcActionData> actions = new ArrayList<NpcAction.NpcActionData>();
            for (ActionConfig acfg : this.config.actions()) {
                NpcAction action = FN.getActionManager().getActionByName(acfg.action());
                if (action == null) {
                    this.logger.warn("Action " + acfg.action() + " is not registered", new Property[0]);
                    continue;
                }
                actions.add(new NpcAction.NpcActionData(actions.size(), action, acfg.value()));
            }
            this.hitbox.getData().getActions().put(ActionTrigger.ANY_CLICK, actions);
            this.hitbox.create();
            this.hitbox.spawnForAll();
            FN.getNpcManager().registerNpc(this.hitbox);
        }
        this.hitbox.getData().setLocation(this.hologram.getData().getLocation());
        NpcAttribute widthAttr = FN.getAttributeManager().getAttributeByName(EntityType.INTERACTION, "width");
        this.hitbox.getData().addAttribute(widthAttr, String.valueOf(this.calcWidth()));
        NpcAttribute heightAttr = FN.getAttributeManager().getAttributeByName(EntityType.INTERACTION, "height");
        this.hitbox.getData().addAttribute(heightAttr, String.valueOf(this.calcHeight()));
        this.hitbox.updateForAll();
    }

    private double calcHeight() {
        int lines = ((TextHologramData)this.hologram.getData()).getText().size();
        double heightPerLine = 0.25;
        double scale = ((TextHologramData)this.hologram.getData()).getScale().y;
        return (double)lines * heightPerLine * scale;
    }

    private double calcWidth() {
        List<String> lines = ((TextHologramData)this.hologram.getData()).getText();
        double maxCharacters = 0.0;
        for (String line : lines) {
            if (!((double)line.length() > maxCharacters)) continue;
            maxCharacters = line.length();
        }
        double widthPerCharacter = 0.12;
        double scale = ((TextHologramData)this.hologram.getData()).getScale().x;
        return maxCharacters * widthPerCharacter * scale;
    }

    public record Configuration(List<ActionConfig> actions) {
    }

    public record ActionConfig(String action, String value) {
    }
}

