/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancysitula.versions.v1_20_6.packets;

import de.oliver.fancysitula.api.entities.FS_RealPlayer;
import de.oliver.fancysitula.api.packets.FS_ClientboundCreateOrUpdateTeamPacket;
import de.oliver.fancysitula.versions.v1_20_6.utils.VanillaPlayerAdapter;
import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.ChatFormatting;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;

public class ClientboundCreateOrUpdateTeamPacketImpl
extends FS_ClientboundCreateOrUpdateTeamPacket {
    private static final Scoreboard SCOREBOARD = new Scoreboard();

    public ClientboundCreateOrUpdateTeamPacketImpl(String teamName, FS_ClientboundCreateOrUpdateTeamPacket.CreateTeam createTeam) {
        super(teamName, createTeam);
    }

    public ClientboundCreateOrUpdateTeamPacketImpl(String teamName, FS_ClientboundCreateOrUpdateTeamPacket.RemoveTeam removeTeam) {
        super(teamName, removeTeam);
    }

    public ClientboundCreateOrUpdateTeamPacketImpl(String teamName, FS_ClientboundCreateOrUpdateTeamPacket.UpdateTeam updateTeam) {
        super(teamName, updateTeam);
    }

    public ClientboundCreateOrUpdateTeamPacketImpl(String teamName, FS_ClientboundCreateOrUpdateTeamPacket.AddEntity addEntity) {
        super(teamName, addEntity);
    }

    public ClientboundCreateOrUpdateTeamPacketImpl(String teamName, FS_ClientboundCreateOrUpdateTeamPacket.RemoveEntity removeEntity) {
        super(teamName, removeEntity);
    }

    @Override
    public Object createPacket() {
        return switch (this.method) {
            default -> throw new MatchException(null, null);
            case FS_ClientboundCreateOrUpdateTeamPacket.Method.CREATE_TEAM -> this.createCreateTeamPacket();
            case FS_ClientboundCreateOrUpdateTeamPacket.Method.REMOVE_TEAM -> this.createRemoveTeamPacket();
            case FS_ClientboundCreateOrUpdateTeamPacket.Method.UPDATE_TEAM -> this.createUpdateTeamPacket();
            case FS_ClientboundCreateOrUpdateTeamPacket.Method.ADD_ENTITY -> this.createAddEntityPacket();
            case FS_ClientboundCreateOrUpdateTeamPacket.Method.REMOVE_ENTITY -> this.createRemoveEntityPacket();
        };
    }

    private Object createCreateTeamPacket() {
        if (this.createTeam == null) {
            return null;
        }
        PlayerTeam playerTeam = new PlayerTeam(SCOREBOARD, this.teamName);
        playerTeam.setDisplayName(PaperAdventure.asVanilla((Component)this.createTeam.getDisplayName()));
        playerTeam.setAllowFriendlyFire(this.createTeam.isAllowFriendlyFire());
        playerTeam.setSeeFriendlyInvisibles(this.createTeam.isCanSeeFriendlyInvisibles());
        playerTeam.setNameTagVisibility(Team.Visibility.byName((String)this.createTeam.getNameTagVisibility().getName()));
        playerTeam.setCollisionRule(Team.CollisionRule.byName((String)this.createTeam.getCollisionRule().getName()));
        playerTeam.setColor(ChatFormatting.getById((int)this.createTeam.getColor().getId()));
        playerTeam.setPlayerPrefix(PaperAdventure.asVanilla((Component)this.createTeam.getPrefix()));
        playerTeam.setPlayerSuffix(PaperAdventure.asVanilla((Component)this.createTeam.getSuffix()));
        for (String entity : this.createTeam.getEntities()) {
            playerTeam.getPlayers().add(entity);
        }
        return ClientboundSetPlayerTeamPacket.createAddOrModifyPacket((PlayerTeam)playerTeam, (boolean)true);
    }

    private Object createRemoveTeamPacket() {
        if (this.removeTeam == null) {
            return null;
        }
        PlayerTeam playerTeam = new PlayerTeam(SCOREBOARD, this.teamName);
        return ClientboundSetPlayerTeamPacket.createRemovePacket((PlayerTeam)playerTeam);
    }

    private Object createUpdateTeamPacket() {
        if (this.updateTeam == null) {
            return null;
        }
        PlayerTeam playerTeam = new PlayerTeam(SCOREBOARD, this.teamName);
        playerTeam.setDisplayName(PaperAdventure.asVanilla((Component)this.updateTeam.getDisplayName()));
        playerTeam.setAllowFriendlyFire(this.updateTeam.isAllowFriendlyFire());
        playerTeam.setSeeFriendlyInvisibles(this.updateTeam.isCanSeeFriendlyInvisibles());
        playerTeam.setNameTagVisibility(Team.Visibility.byName((String)this.updateTeam.getNameTagVisibility().getName()));
        playerTeam.setCollisionRule(Team.CollisionRule.byName((String)this.updateTeam.getCollisionRule().getName()));
        playerTeam.setColor(ChatFormatting.getById((int)this.updateTeam.getColor().getId()));
        playerTeam.setPlayerPrefix(PaperAdventure.asVanilla((Component)this.updateTeam.getPrefix()));
        playerTeam.setPlayerSuffix(PaperAdventure.asVanilla((Component)this.updateTeam.getSuffix()));
        return ClientboundSetPlayerTeamPacket.createAddOrModifyPacket((PlayerTeam)playerTeam, (boolean)true);
    }

    private Object createAddEntityPacket() {
        if (this.addEntity == null) {
            return null;
        }
        PlayerTeam playerTeam = new PlayerTeam(SCOREBOARD, this.teamName);
        for (String entity : this.addEntity.getEntities()) {
            playerTeam.getPlayers().add(entity);
        }
        return ClientboundSetPlayerTeamPacket.createMultiplePlayerPacket((PlayerTeam)playerTeam, this.addEntity.getEntities(), (ClientboundSetPlayerTeamPacket.Action)ClientboundSetPlayerTeamPacket.Action.ADD);
    }

    private Object createRemoveEntityPacket() {
        if (this.removeEntity == null) {
            return null;
        }
        PlayerTeam playerTeam = new PlayerTeam(SCOREBOARD, this.teamName);
        for (String entity : this.removeEntity.getEntities()) {
            playerTeam.getPlayers().add(entity);
        }
        return ClientboundSetPlayerTeamPacket.createMultiplePlayerPacket((PlayerTeam)playerTeam, this.removeEntity.getEntities(), (ClientboundSetPlayerTeamPacket.Action)ClientboundSetPlayerTeamPacket.Action.REMOVE);
    }

    @Override
    protected void sendPacketTo(FS_RealPlayer player) {
        ClientboundSetPlayerTeamPacket packet = (ClientboundSetPlayerTeamPacket)this.createPacket();
        ServerPlayer vanillaPlayer = VanillaPlayerAdapter.asVanilla(player.getBukkitPlayer());
        vanillaPlayer.connection.send((Packet)packet);
    }
}

