/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.hologram.version;

import com.mojang.math.Transformation;
import de.oliver.fancyholograms.api.data.BlockHologramData;
import de.oliver.fancyholograms.api.data.DisplayHologramData;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.data.ItemHologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.events.HologramHideEvent;
import de.oliver.fancyholograms.api.events.HologramShowEvent;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancyholograms.hologram.version.MappingKeys1_20_4;
import de.oliver.fancylib.ReflectionUtils;
import io.papermc.paper.adventure.PaperAdventure;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.Brightness;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public final class Hologram1_20_4
extends Hologram {
    @Nullable
    private Display display;

    public Hologram1_20_4(@NotNull HologramData data) {
        super(data);
    }

    @Override
    public int getEntityId() {
        return this.display.aj();
    }

    @Override
    @Nullable
    public org.bukkit.entity.Display getDisplayEntity() {
        return this.display != null ? (org.bukkit.entity.Display)this.display.getBukkitEntity() : null;
    }

    @Override
    public void create() {
        Location location = this.data.getLocation();
        if (!location.isWorldLoaded()) {
            return;
        }
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        switch (this.data.getType()) {
            case TEXT: {
                this.display = new Display.TextDisplay(EntityTypes.aY, (World)world);
                break;
            }
            case BLOCK: {
                this.display = new Display.BlockDisplay(EntityTypes.j, (World)world);
                break;
            }
            case ITEM: {
                this.display = new Display.ItemDisplay(EntityTypes.af, (World)world);
            }
        }
        HologramData hologramData = this.data;
        if (hologramData instanceof DisplayHologramData) {
            DisplayHologramData dd = (DisplayHologramData)hologramData;
            Object DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID = ReflectionUtils.getStaticValue(Display.class, MappingKeys1_20_4.DISPLAY__DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID.getMapping());
            this.display.an().b((DataWatcherObject)DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID, (Object)dd.getInterpolationDuration());
            Object DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID = ReflectionUtils.getStaticValue(Display.class, MappingKeys1_20_4.DISPLAY__DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID.getMapping());
            this.display.an().b((DataWatcherObject)DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID, (Object)0);
        }
        this.update();
    }

    @Override
    public void delete() {
        this.display = null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void update() {
        block27: {
            block26: {
                display = this.display;
                if (display == null) {
                    return;
                }
                location = this.data.getLocation();
                if (location.getWorld() == null || !location.isWorldLoaded()) {
                    return;
                }
                display.p(location.x(), location.y(), location.z());
                display.r(location.getYaw());
                display.s(location.getPitch());
                if (!(display instanceof Display.TextDisplay)) break block26;
                textDisplay = (Display.TextDisplay)display;
                var9_4 = this.data;
                if (!(var9_4 instanceof TextHologramData)) break block26;
                textData = (TextHologramData)var9_4;
                DATA_LINE_WIDTH_ID = ReflectionUtils.getStaticValue(Display.TextDisplay.class, MappingKeys1_20_4.TEXT_DISPLAY__DATA_LINE_WIDTH_ID.getMapping());
                display.an().b((DataWatcherObject)DATA_LINE_WIDTH_ID, (Object)1000);
                DATA_BACKGROUND_COLOR_ID = ReflectionUtils.getStaticValue(Display.TextDisplay.class, MappingKeys1_20_4.TEXT_DISPLAY__DATA_BACKGROUND_COLOR_ID.getMapping());
                background = textData.getBackground();
                if (background == null) {
                    display.an().b((DataWatcherObject)DATA_BACKGROUND_COLOR_ID, (Object)0x40000000);
                } else if (background == Hologram.TRANSPARENT) {
                    display.an().b((DataWatcherObject)DATA_BACKGROUND_COLOR_ID, (Object)0);
                } else {
                    display.an().b((DataWatcherObject)DATA_BACKGROUND_COLOR_ID, (Object)background.asARGB());
                }
                if (textData.hasTextShadow()) {
                    textDisplay.d((byte)(textDisplay.z() | 1));
                } else {
                    textDisplay.d((byte)(textDisplay.z() & -2));
                }
                if (textData.getTextAlignment() == TextDisplay.TextAlignment.LEFT) {
                    textDisplay.d((byte)(textDisplay.z() | 8));
                } else {
                    textDisplay.d((byte)(textDisplay.z() & -9));
                }
                if (textData.isSeeThrough()) {
                    textDisplay.d((byte)(textDisplay.z() | 2));
                } else {
                    textDisplay.d((byte)(textDisplay.z() & -3));
                }
                if (textData.getTextAlignment() == TextDisplay.TextAlignment.RIGHT) {
                    textDisplay.d((byte)(textDisplay.z() | 16));
                } else {
                    textDisplay.d((byte)(textDisplay.z() & -17));
                }
                break block27;
            }
            if (!(display instanceof Display.ItemDisplay)) ** GOTO lbl-1000
            itemDisplay = (Display.ItemDisplay)display;
            DATA_LINE_WIDTH_ID = this.data;
            if (DATA_LINE_WIDTH_ID instanceof ItemHologramData) {
                itemData = (ItemHologramData)DATA_LINE_WIDTH_ID;
                itemDisplay.a(net.minecraft.world.item.ItemStack.fromBukkitCopy((ItemStack)itemData.getItemStack()));
            } else if (display instanceof Display.BlockDisplay) {
                blockDisplay = (Display.BlockDisplay)display;
                DATA_LINE_WIDTH_ID = this.data;
                if (DATA_LINE_WIDTH_ID instanceof BlockHologramData) {
                    blockData = (BlockHologramData)DATA_LINE_WIDTH_ID;
                    block = (Block)BuiltInRegistries.e.a(MinecraftKey.a((String)("minecraft:" + blockData.getBlock().name().toLowerCase()), (char)':'));
                    blockDisplay.c(block.o());
                }
            }
        }
        var4_5 = this.data;
        if (var4_5 instanceof DisplayHologramData) {
            displayData = (DisplayHologramData)var4_5;
            switch (1.$SwitchMap$org$bukkit$entity$Display$Billboard[displayData.getBillboard().ordinal()]) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case 1: {
                    v0 = Display.BillboardConstraints.a;
                    break;
                }
                case 2: {
                    v0 = Display.BillboardConstraints.b;
                    break;
                }
                case 3: {
                    v0 = Display.BillboardConstraints.c;
                    break;
                }
                case 4: {
                    v0 = Display.BillboardConstraints.d;
                }
            }
            display.a(v0);
            if (displayData.getBrightness() != null) {
                display.a(new Brightness(displayData.getBrightness().getBlockLight(), displayData.getBrightness().getSkyLight()));
            }
            display.a(new Transformation(displayData.getTranslation(), new Quaternionf(), displayData.getScale(), new Quaternionf()));
            display.c(displayData.getShadowRadius());
            display.u(displayData.getShadowStrength());
            display.b((float)displayData.getVisibilityDistance());
        }
    }

    @Override
    public boolean show(@NotNull Player player) {
        Display display;
        if (!new HologramShowEvent((Hologram)this, player).callEvent()) {
            return false;
        }
        if (this.display == null) {
            this.create();
        }
        if ((display = this.display) == null) {
            return false;
        }
        if (!this.data.getLocation().getWorld().getName().equals(player.getLocation().getWorld().getName())) {
            return false;
        }
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.c.b((Packet)new PacketPlayOutSpawnEntity((Entity)display));
        this.viewers.add(player.getUniqueId());
        this.refreshHologram(player);
        return true;
    }

    @Override
    public boolean hide(@NotNull Player player) {
        if (!new HologramHideEvent((Hologram)this, player).callEvent()) {
            return false;
        }
        Display display = this.display;
        if (display == null) {
            return false;
        }
        ((CraftPlayer)player).getHandle().c.b((Packet)new PacketPlayOutEntityDestroy(new int[]{display.aj()}));
        this.viewers.remove(player.getUniqueId());
        return true;
    }

    @Override
    public void refresh(@NotNull Player player) {
        Display display = this.display;
        if (display == null) {
            return;
        }
        if (!this.isViewer(player)) {
            return;
        }
        ((CraftPlayer)player).getHandle().c.b((Packet)new PacketPlayOutEntityTeleport((Entity)display));
        if (display instanceof Display.TextDisplay) {
            Display.TextDisplay textDisplay = (Display.TextDisplay)display;
            textDisplay.c(PaperAdventure.asVanilla((Component)this.getShownText(player)));
        }
        ArrayList<DataWatcher.b> values = new ArrayList<DataWatcher.b>();
        for (DataWatcher.Item item : ((Int2ObjectMap)ReflectionUtils.getValue(display.an(), "e")).values()) {
            values.add(item.e());
        }
        ((CraftPlayer)player).getHandle().c.b((Packet)new PacketPlayOutEntityMetadata(display.aj(), values));
    }
}

