/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.listeners;

import de.oliver.fancyholograms.FancyHolograms;
import de.oliver.fancyholograms.api.hologram.Hologram;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;

public final class PlayerListener
implements Listener {
    @NotNull
    private final FancyHolograms plugin;
    private final Map<UUID, List<UUID>> loadingResourcePacks;

    public PlayerListener(@NotNull FancyHolograms plugin) {
        this.plugin = plugin;
        this.loadingResourcePacks = new HashMap<UUID, List<UUID>>();
    }

    @NotNull
    private static UUID getResourcePackID(@NotNull PlayerResourcePackStatusEvent event) {
        try {
            event.getClass().getMethod("getID", new Class[0]);
            return event.getID();
        }
        catch (NoSuchMethodException e) {
            return new UUID(0L, 0L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(@NotNull PlayerQuitEvent event) {
        FancyHolograms.get().getHologramThread().submit(() -> {
            for (Hologram hologram : this.plugin.getHologramsManager().getHolograms()) {
                hologram.forceHideHologram(event.getPlayer());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(@NotNull PlayerJoinEvent event) {
        FancyHolograms.get().getHologramThread().submit(() -> {
            for (Hologram hologram : this.plugin.getHologramsManager().getHolograms()) {
                hologram.forceHideHologram(event.getPlayer());
                hologram.forceUpdateShownStateFor(event.getPlayer());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onTeleport(@NotNull PlayerTeleportEvent event) {
        FancyHolograms.get().getHologramThread().submit(() -> {
            for (Hologram hologram : this.plugin.getHologramsManager().getHolograms()) {
                hologram.forceUpdateShownStateFor(event.getPlayer());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChange(@NotNull PlayerChangedWorldEvent event) {
        FancyHolograms.get().getHologramThread().submit(() -> {
            for (Hologram hologram : this.plugin.getHologramsManager().getHolograms()) {
                hologram.forceUpdateShownStateFor(event.getPlayer());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onResourcePackStatus(@NotNull PlayerResourcePackStatusEvent event) {
        if (!event.getPlayer().isOnline()) {
            return;
        }
        UUID playerUniqueId = event.getPlayer().getUniqueId();
        UUID packUniqueId = PlayerListener.getResourcePackID(event);
        if (event.getStatus() == PlayerResourcePackStatusEvent.Status.ACCEPTED) {
            this.loadingResourcePacks.computeIfAbsent(playerUniqueId, ___ -> new ArrayList()).add(packUniqueId);
        } else if (event.getStatus() == PlayerResourcePackStatusEvent.Status.SUCCESSFULLY_LOADED || event.getStatus() == PlayerResourcePackStatusEvent.Status.FAILED_DOWNLOAD) {
            this.loadingResourcePacks.computeIfAbsent(playerUniqueId, ___ -> new ArrayList()).removeIf(uuid -> uuid.equals(packUniqueId));
            if (this.loadingResourcePacks.get(playerUniqueId) != null && this.loadingResourcePacks.get(playerUniqueId).isEmpty()) {
                this.loadingResourcePacks.remove(playerUniqueId);
                FancyHolograms.get().getHologramThread().submit(() -> {
                    for (Hologram hologram : this.plugin.getHologramsManager().getHolograms()) {
                        hologram.refreshHologram(event.getPlayer());
                    }
                });
            }
        }
    }
}

