/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.api.trait;

import com.fancyinnovations.fancyholograms.api.events.HologramTraitAttachedEvent;
import com.fancyinnovations.fancyholograms.api.trait.HologramTrait;
import com.fancyinnovations.fancyholograms.api.trait.HologramTraitClass;
import com.fancyinnovations.fancyholograms.api.trait.HologramTraitRegistry;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

@HologramTraitClass(traitName="trait_trait")
public class HologramTraitTrait
extends HologramTrait {
    private final List<HologramTrait> traits = new ArrayList<HologramTrait>();

    public void addTrait(HologramTrait trait) {
        this.traits.add(trait);
        if (this.hologram != null) {
            if (!new HologramTraitAttachedEvent(this.hologram, trait, false).callEvent()) {
                return;
            }
            trait.attachHologram(this.hologram);
        }
    }

    public void addTrait(Class<? extends HologramTrait> trait) {
        try {
            HologramTrait newTrait = trait.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.addTrait(newTrait);
        }
        catch (Exception e) {
            this.logger.error("Failed to instantiate trait " + trait.getSimpleName(), ThrowableProperty.of(e));
        }
    }

    public void removeTrait(HologramTrait trait) {
        if (this.traits.remove(trait)) {
            if (this.hologram != null) {
                trait.onUnregister();
                this.logger.debug("Detached trait " + trait.getClass().getSimpleName() + " from hologram " + this.hologram.getData().getName(), new Property[0]);
            }
        } else {
            this.logger.warn("Trait " + trait.getClass().getSimpleName() + " not found in hologram " + this.hologram.getData().getName(), new Property[0]);
        }
    }

    public void removeTrait(Class<? extends HologramTrait> trait) {
        for (HologramTrait t : this.traits) {
            if (!t.getClass().equals(trait)) continue;
            this.removeTrait(t);
            return;
        }
        this.logger.warn("Trait " + trait.getSimpleName() + " not found in hologram " + this.hologram.getData().getName(), new Property[0]);
    }

    @Override
    public void onAttach() {
        List<HologramTraitRegistry.TraitInfo> registeredTraits = this.api.getTraitRegistry().getTraits();
        for (HologramTraitRegistry.TraitInfo ti : registeredTraits) {
            if (!ti.isDefault()) continue;
            try {
                HologramTrait trait = ti.clazz().getConstructor(new Class[0]).newInstance(new Object[0]);
                this.traits.add(trait);
            }
            catch (Exception e) {
                this.logger.error("Failed to instantiate default trait " + ti.name(), ThrowableProperty.of(e));
            }
            this.logger.debug("Attached default trait " + ti.name() + " to hologram " + this.hologram.getData().getName(), new Property[0]);
        }
        for (HologramTrait trait : this.traits) {
            if (!new HologramTraitAttachedEvent(this.hologram, trait, false).callEvent()) continue;
            trait.attachHologram(this.hologram);
        }
    }

    @Override
    public void onSpawn(Player player) {
        for (HologramTrait trait : this.traits) {
            trait.onSpawn(player);
        }
    }

    @Override
    public void onDespawn(Player player) {
        for (HologramTrait trait : this.traits) {
            trait.onDespawn(player);
        }
    }

    @Override
    public void onUpdate(Player player) {
        for (HologramTrait trait : this.traits) {
            trait.onUpdate(player);
        }
    }

    @Override
    public void onModify() {
        for (HologramTrait trait : this.traits) {
            trait.onModify();
        }
    }

    @Override
    public void onRegister() {
        for (HologramTrait trait : this.traits) {
            trait.onRegister();
        }
    }

    @Override
    public void onUnregister() {
        for (HologramTrait trait : this.traits) {
            trait.onUnregister();
        }
    }

    @Override
    public void load() {
        for (HologramTrait trait : this.traits) {
            trait.load();
        }
    }

    @Override
    public void save() {
        for (HologramTrait trait : this.traits) {
            trait.save();
        }
    }

    public List<HologramTrait> getTraits() {
        return this.traits;
    }
}

