/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands.hologram;

import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.events.HologramUpdateEvent;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.commands.HologramCMD;
import com.fancyinnovations.fancyholograms.commands.Subcommand;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import de.oliver.fancylib.MessageHelper;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeeThroughCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        Boolean enabled;
        if (!player.hasPermission("fancyholograms.hologram.edit.see_trough")) {
            MessageHelper.error(player, "You don't have the required permission to edit a hologram");
            return false;
        }
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof TextHologramData)) {
            MessageHelper.error(player, "This command can only be used on text holograms");
            return false;
        }
        TextHologramData textData = (TextHologramData)hologramData;
        switch (args[3].toLowerCase(Locale.ROOT)) {
            case "true": {
                Boolean bl = true;
                break;
            }
            case "false": {
                Boolean bl = false;
                break;
            }
            default: {
                Boolean bl = enabled = null;
            }
        }
        if (enabled == null) {
            MessageHelper.error(player, "Could not parse see through flag");
            return false;
        }
        if (enabled.booleanValue() == textData.isSeeThrough()) {
            MessageHelper.warning(player, "This hologram already has see through " + (enabled != false ? "enabled" : "disabled"));
            return false;
        }
        TextHologramData copied = textData.copy(textData.getName());
        copied.setSeeThrough(enabled);
        if (!HologramCMD.callModificationEvent(hologram, player, copied, HologramUpdateEvent.HologramModification.SEE_THROUGH)) {
            return false;
        }
        if (enabled.booleanValue() == textData.isSeeThrough()) {
            MessageHelper.warning(player, "This hologram already has see through " + (enabled != false ? "enabled" : "disabled"));
            return false;
        }
        textData.setSeeThrough(copied.isSeeThrough());
        if (FancyHologramsPlugin.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHologramsPlugin.get().getStorage().save(hologram.getData());
        }
        MessageHelper.success(player, "Changed see through");
        return true;
    }
}

