/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.converter;

import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.ItemHologramData;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.converter.HologramConversionSession;
import com.fancyinnovations.fancyholograms.converter.HologramConverter;
import de.oliver.fancylib.MessageHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Display;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class DecentHologramsConverter
extends HologramConverter {
    private static final float VANILLA_PIXEL_BLOCK_SIZE = 0.0625f;
    private static final float TEXT_DISPLAY_PIXEL = 0.020833334f;
    private static final float TEXT_DISPLAY_LINE_HEIGHT = 0.2916667f;
    private static final String PROCESS_ICONS_FLAG = "--processIcons";
    private static final String ICON_PREFIX = "#ICON: ";
    private static final File DECENT_HOLOGRAMS_DATA = new File("./plugins/DecentHolograms/holograms/");

    @Override
    @NotNull
    public String getId() {
        return "DecentHolograms";
    }

    @Override
    public boolean canRunConverter() {
        return DECENT_HOLOGRAMS_DATA.exists();
    }

    @Override
    @NotNull
    public List<HologramData> convertHolograms(@NotNull HologramConversionSession spec) {
        boolean processIcons = Arrays.stream(spec.getAdditionalArguments()).anyMatch(arg -> arg.equalsIgnoreCase(PROCESS_ICONS_FLAG));
        if (processIcons) {
            MessageHelper.warning(spec.getInvoker(), "--processIcons argument is experimental and may produce unexpected results.");
        } else {
            MessageHelper.info(spec.getInvoker(), "Any lines containing an #ICON will be removed. You may run with --processIcons to attempt conversion, but this is experimental.");
        }
        List<String> targetHolograms = this.getConvertableHolograms().stream().filter(id -> spec.getTarget().matches((String)id)).toList();
        if (targetHolograms.isEmpty()) {
            throw new RuntimeException("The provided target matches no holograms.");
        }
        ArrayList<HologramData> converted = new ArrayList<HologramData>();
        for (String id2 : targetHolograms) {
            List<HologramData> results = this.convert(id2, processIcons);
            if (results.isEmpty()) {
                spec.logUnsuccessfulConversion(id2, "Unable to convert this hologram, there is no convertable content.");
            } else {
                spec.logSuccessfulConversion(id2, results);
            }
            converted.addAll(results);
        }
        return converted;
    }

    @Override
    @NotNull
    public List<String> getConvertableHolograms() {
        File[] files = DECENT_HOLOGRAMS_DATA.listFiles();
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).map(file -> file.getName().replace(".yml", "")).toList();
    }

    @NotNull
    private List<HologramData> convert(@NotNull String hologramId, boolean processIcons) {
        List firstPageSections;
        File file = DECENT_HOLOGRAMS_DATA.toPath().resolve((String)(hologramId.endsWith(".yml") ? hologramId : hologramId + ".yml")).toFile();
        if (!file.exists() || !file.canRead()) {
            throw new RuntimeException("File does not exist or is not readable.");
        }
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)file);
        Objects.requireNonNull(data, "No data could be read from the DecentHolograms file!");
        Location location = this.parseLocation(data.getString("location"));
        double displayRange = data.getDouble("display-range");
        int updateInterval = data.getInt("update-interval");
        Object firstPage = ((Map)data.getMapList("pages").stream().findFirst().orElseThrow(() -> new RuntimeException(String.format("There are no pages for %s!", hologramId)))).get("lines");
        Objects.requireNonNull(firstPage, String.format("There is no first page for %s!", hologramId));
        try {
            firstPageSections = (List)firstPage;
        }
        catch (ClassCastException ignored) {
            throw new RuntimeException(String.format("The first page for %s is invalid!", hologramId));
        }
        List<String> lines = firstPageSections.stream().map(line -> (String)line.get("content")).toList();
        if (!processIcons) {
            lines = lines.stream().map(line -> line.startsWith(ICON_PREFIX) ? "" : line).toList();
        }
        TextHologramData hologram = new TextHologramData(hologramId, location);
        hologram.setText(lines);
        hologram.setTextShadow(true);
        hologram.setTextUpdateInterval(updateInterval);
        hologram.setVisibilityDistance((int)displayRange);
        hologram.setBillboard(Display.Billboard.VERTICAL);
        hologram.setPersistent(true);
        ArrayList<HologramData> results = new ArrayList<HologramData>();
        if (processIcons) {
            results.addAll(this.convertSplitLines(hologram, firstPageSections));
        } else {
            results.add(hologram);
        }
        return results;
    }

    @NotNull
    private List<HologramData> convertSplitLines(@NotNull TextHologramData base, @NotNull List<Map<String, ?>> lines) {
        ArrayList<HologramData> stack = new ArrayList<HologramData>();
        ArrayList<String> finalBaseLines = new ArrayList<String>();
        stack.add(base);
        int subTypes = 0;
        float currentYOffset = 0.0f;
        float totalHeight = 0.0f;
        for (Map<String, ?> entry : lines) {
            Object contentEntry = entry.get("content");
            if (!(contentEntry instanceof String)) continue;
            String line = (String)contentEntry;
            if (line.startsWith(ICON_PREFIX)) {
                String materialTypeString = line.replace(ICON_PREFIX, "");
                Material material = Material.valueOf((String)materialTypeString);
                String formattedId = String.format("%s_icon_%s", base.getName(), subTypes++);
                ItemHologramData data = new ItemHologramData(formattedId, base.getLocation());
                data.setItemStack(new ItemStack(material));
                data.setBillboard(Display.Billboard.VERTICAL);
                data.setScale(new Vector3f(0.45f, 0.45f, 0.45f));
                data.setTranslation(new Vector3f(0.0f, currentYOffset, 0.0f));
                data.setVisibilityDistance(base.getVisibilityDistance());
                data.setPersistent(true);
                float h = 0.4116667f;
                currentYOffset += h;
                totalHeight += h;
                finalBaseLines.addAll(List.of("&r", "&r"));
                stack.add(data);
                continue;
            }
            finalBaseLines.add(line);
            float h = 0.2916667f;
            currentYOffset += h;
            totalHeight += h;
        }
        base.setText(finalBaseLines);
        for (HologramData holo : stack) {
            if (!(holo instanceof ItemHologramData)) continue;
            ItemHologramData itemHolo = (ItemHologramData)holo;
            itemHolo.setTranslation(new Vector3f(itemHolo.getTranslation().x, totalHeight - itemHolo.getTranslation().y - 0.25f, itemHolo.getTranslation().z));
        }
        return stack;
    }

    @NotNull
    private Location parseLocation(@Nullable String location) {
        Objects.requireNonNull(location, "Location cannot be empty!");
        String[] split = location.split(":");
        if (split.length != 4) {
            throw new IllegalStateException(String.format("Location in %s didn't have 4 arguments (split by :)", location));
        }
        World world = Objects.requireNonNull(Bukkit.getWorld((String)split[0]), String.format("World does not exist for location %s", location));
        double x = Double.parseDouble(split[1]);
        double y = Double.parseDouble(split[2]);
        double z = Double.parseDouble(split[3]);
        return new Location(world, x, y, z);
    }
}

