/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.storage.json;

import com.fancyinnovations.fancyholograms.api.FancyHolograms;
import com.fancyinnovations.fancyholograms.api.data.BlockHologramData;
import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.ItemHologramData;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.hologram.HologramType;
import com.fancyinnovations.fancyholograms.storage.HologramStorage;
import com.fancyinnovations.fancyholograms.storage.json.JsonAdapter;
import com.fancyinnovations.fancyholograms.storage.json.model.JsonDataUnion;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import de.oliver.jdb.JDB;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class JsonStorage
implements HologramStorage {
    private static final String DATA_DIR_PATH = "plugins/FancyHolograms/data/holograms";
    private static final File DATA_DIR = new File("plugins/FancyHolograms/data/holograms");
    private final JDB jdb = new JDB("plugins/FancyHolograms/data/holograms");

    @Override
    public void saveBatch(Collection<HologramData> holograms) {
        for (HologramData hologram : holograms) {
            this.save(hologram);
        }
    }

    @Override
    public void save(HologramData hologram) {
        if (hologram.getFilePath() == null || hologram.getFilePath().isEmpty()) {
            FancyHolograms.get().getFancyLogger().error("Hologram " + hologram.getName() + " has no file path set", new Property[0]);
            return;
        }
        JsonDataUnion union = switch (hologram.getType()) {
            default -> throw new MatchException(null, null);
            case HologramType.TEXT -> JsonAdapter.toUnion((TextHologramData)hologram);
            case HologramType.ITEM -> JsonAdapter.toUnion((ItemHologramData)hologram);
            case HologramType.BLOCK -> JsonAdapter.toUnion((BlockHologramData)hologram);
        };
        try {
            JsonDataUnion[] existing = this.jdb.get(hologram.getFilePath(), JsonDataUnion[].class);
            if (existing == null) {
                existing = new JsonDataUnion[]{};
            }
            for (int i = 0; i < existing.length; ++i) {
                JsonDataUnion u = existing[i];
                if (!u.hologram_data().name().equals(hologram.getName())) continue;
                existing[i] = union;
                this.jdb.set(hologram.getFilePath(), existing);
                hologram.getTraitTrait().save();
                return;
            }
            JsonDataUnion[] newArray = new JsonDataUnion[existing.length + 1];
            System.arraycopy(existing, 0, newArray, 0, existing.length);
            newArray[existing.length] = union;
            this.jdb.set(hologram.getFilePath(), newArray);
        }
        catch (IOException e) {
            FancyHolograms.get().getFancyLogger().error("Failed to save hologram " + hologram.getName(), ThrowableProperty.of(e));
        }
        hologram.getTraitTrait().save();
    }

    @Override
    public void delete(HologramData hologram) {
        try {
            JsonDataUnion[] existing = this.jdb.get(hologram.getFilePath(), JsonDataUnion[].class);
            if (existing == null) {
                return;
            }
            ArrayList<JsonDataUnion> newArray = new ArrayList<JsonDataUnion>();
            for (JsonDataUnion u : existing) {
                if (u.hologram_data().name().equals(hologram.getName())) continue;
                newArray.add(u);
            }
            if (newArray.size() == existing.length) {
                FancyHolograms.get().getFancyLogger().warn("Hologram " + hologram.getName() + " not found in file " + hologram.getFilePath(), new Property[0]);
                return;
            }
            if (newArray.isEmpty()) {
                this.jdb.delete(hologram.getFilePath());
                return;
            }
            this.jdb.set(hologram.getFilePath(), newArray.toArray(new JsonDataUnion[0]));
        }
        catch (IOException e) {
            FancyHolograms.get().getFancyLogger().error("Failed to save hologram " + hologram.getName(), ThrowableProperty.of(e));
        }
    }

    @Override
    public Collection<HologramData> loadAll(String path) {
        ArrayList<HologramData> holograms = new ArrayList<HologramData>();
        File dir = new File(DATA_DIR, path);
        if (!dir.isDirectory()) {
            return holograms;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return holograms;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (file.isDirectory()) {
                holograms.addAll(this.loadAll(path + "/" + fileName));
                continue;
            }
            if (fileName.startsWith(".") || fileName.startsWith("_")) continue;
            if (fileName.endsWith(".json")) {
                holograms.addAll(this.loadFile(path + "/" + fileName.substring(0, fileName.length() - 5)));
                continue;
            }
            FancyHolograms.get().getFancyLogger().warn("File " + fileName + " is not a valid hologram file", new Property[0]);
        }
        return holograms;
    }

    public Collection<HologramData> loadFile(String path) {
        ArrayList<HologramData> holograms = new ArrayList<HologramData>();
        try {
            JsonDataUnion[] allTextUnions = this.jdb.get(path, JsonDataUnion[].class);
            if (allTextUnions == null) {
                FancyHolograms.get().getFancyLogger().debug("File " + path + " is empty or does not exist", new Property[0]);
                return holograms;
            }
            for (JsonDataUnion union : allTextUnions) {
                HologramData data = JsonAdapter.fromJson(union);
                data.getTraitTrait().load();
                data.setFilePath(path);
                holograms.add(data);
            }
        }
        catch (IOException e) {
            FancyHolograms.get().getFancyLogger().error("Failed to load all holograms from " + path, ThrowableProperty.of(e));
        }
        return holograms;
    }
}

