/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.tests.api;

import com.fancyinnovations.fancyholograms.api.HologramRegistry;
import com.fancyinnovations.fancyholograms.api.data.BlockHologramData;
import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.ItemHologramData;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.data.builder.BlockHologramBuilder;
import com.fancyinnovations.fancyholograms.api.data.builder.ItemHologramBuilder;
import com.fancyinnovations.fancyholograms.api.data.builder.TextHologramBuilder;
import com.fancyinnovations.fancyholograms.api.data.property.Visibility;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.api.hologram.HologramType;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import com.fancyinnovations.fancyholograms.trait.builtin.DebugTrait;
import de.oliver.plugintests.Expectable;
import de.oliver.plugintests.annotations.FPTest;
import java.util.List;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.joml.Vector3f;

public class HologramBuilderTest {
    @FPTest(name="Test basic text hologram builder")
    public void testTextHologramBuilder(Player player) {
        Hologram hologram = TextHologramBuilder.create("Test", player.getLocation()).build();
        Expectable.expect(hologram).toBeDefined();
        Expectable.expect(hologram.getData()).toBeDefined();
        Expectable.expect(hologram.getData().getName()).toBe("Test");
        Expectable.expect(hologram.getData().getLocation()).toEqual(player.getLocation());
        Expectable.expect(hologram.getData().getType()).toEqual(HologramType.TEXT);
    }

    @FPTest(name="Test text hologram builder with one line")
    public void testTextHologramBuilderWithOneLine(Player player) {
        Hologram hologram = TextHologramBuilder.create("Test", player.getLocation()).text("Custom line").build();
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof TextHologramData)) {
            throw new AssertionError((Object)"Hologram is not a text hologram");
        }
        TextHologramData data = (TextHologramData)hologramData;
        Expectable.expect(data.getText().size()).toEqual(1);
        Expectable.expect(data.getText().getFirst()).toEqual("Custom line");
    }

    @FPTest(name="Test text hologram builder with multiple line")
    public void testTextHologramBuilderWithMultipleLines(Player player) {
        Hologram hologram = TextHologramBuilder.create("Test", player.getLocation()).text("Custom line", "Another line", "Yet another line").build();
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof TextHologramData)) {
            throw new AssertionError((Object)"Hologram is not a text hologram");
        }
        TextHologramData data = (TextHologramData)hologramData;
        Expectable.expect(data.getText().size()).toEqual(3);
        Expectable.expect(data.getText().getFirst()).toEqual("Custom line");
        Expectable.expect(data.getText().get(1)).toEqual("Another line");
        Expectable.expect(data.getText().getLast()).toEqual("Yet another line");
    }

    @FPTest(name="Test text hologram builder with multiple line 2")
    public void testTextHologramBuilderWithMultipleLines2(Player player) {
        Hologram hologram = TextHologramBuilder.create("Test", player.getLocation()).text(List.of("Custom line", "Another line", "Yet another line")).build();
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof TextHologramData)) {
            throw new AssertionError((Object)"Hologram is not a text hologram");
        }
        TextHologramData data = (TextHologramData)hologramData;
        Expectable.expect(data.getText().size()).toEqual(3);
        Expectable.expect(data.getText().getFirst()).toEqual("Custom line");
        Expectable.expect(data.getText().get(1)).toEqual("Another line");
        Expectable.expect(data.getText().getLast()).toEqual("Yet another line");
    }

    @FPTest(name="Test text hologram builder with properties")
    public void testTextHologramBuilderWithProperties(Player player) {
        Hologram hologram = TextHologramBuilder.create("Test", player.getLocation()).text("Custom line").background(Color.BLACK).textAlignment(TextDisplay.TextAlignment.LEFT).textShadow(true).seeThrough(true).updateTextInterval(420).visibilityDistance(42).visibility(Visibility.ALL).persistent(false).linkedNpcName("TestNPC").trait(DebugTrait.class).billboard(Display.Billboard.FIXED).scale(3.0f, 5.0f, 6.0f).translation(1.0f, 2.0f, 3.0f).brightness(7, 3).shadowRadius(0.5f).shadowStrength(0.7f).interpolationDuration(100).build();
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof TextHologramData)) {
            throw new AssertionError((Object)"Hologram is not a text hologram");
        }
        TextHologramData data = (TextHologramData)hologramData;
        Expectable.expect(data.getText().size()).toEqual(1);
        Expectable.expect(data.getText().getFirst()).toEqual("Custom line");
        Expectable.expect(data.getBackground()).toEqual(Color.BLACK);
        Expectable.expect(data.getTextAlignment()).toEqual(TextDisplay.TextAlignment.LEFT);
        Expectable.expect(data.hasTextShadow()).toBe(true);
        Expectable.expect(data.isSeeThrough()).toBe(true);
        Expectable.expect(data.getTextUpdateInterval()).toEqual(420);
        Expectable.expect(data.getVisibilityDistance()).toEqual(42);
        Expectable.expect(data.getVisibility()).toEqual(Visibility.ALL);
        Expectable.expect(data.isPersistent()).toBe(false);
        Expectable.expect(data.getLinkedNpcName()).toEqual("TestNPC");
        Expectable.expect(data.getTraitTrait().isTraitAttached(DebugTrait.class)).toBe(true);
        Expectable.expect(data.getBillboard()).toEqual(Display.Billboard.FIXED);
        Expectable.expect(data.getScale()).toEqual(new Vector3f(3.0f, 5.0f, 6.0f));
        Expectable.expect(data.getTranslation()).toEqual(new Vector3f(1.0f, 2.0f, 3.0f));
        Expectable.expect(data.getBrightness()).toEqual(new Display.Brightness(7, 3));
        Expectable.expect(Float.valueOf(data.getShadowRadius())).toEqual(Float.valueOf(0.5f));
        Expectable.expect(Float.valueOf(data.getShadowStrength())).toEqual(Float.valueOf(0.7f));
        Expectable.expect(data.getInterpolationDuration()).toEqual(100);
    }

    @FPTest(name="Test item hologram builder")
    public void testItemHologramBuilder(Player player) {
        ItemStack item = new ItemStack(Material.DIAMOND_PICKAXE);
        Hologram hologram = ItemHologramBuilder.create("Test", player.getLocation()).item(item).build();
        Expectable.expect(hologram).toBeDefined();
        Expectable.expect(hologram.getData()).toBeDefined();
        Expectable.expect(hologram.getData().getName()).toBe("Test");
        Expectable.expect(hologram.getData().getLocation()).toEqual(player.getLocation());
        Expectable.expect(hologram.getData().getType()).toEqual(HologramType.ITEM);
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof ItemHologramData)) {
            throw new AssertionError((Object)"Hologram is not an item hologram");
        }
        ItemHologramData data = (ItemHologramData)hologramData;
        Expectable.expect(data.getItemStack()).toEqual(item);
    }

    @FPTest(name="Test block hologram builder")
    public void testBlockHologramBuilder(Player player) {
        Hologram hologram = BlockHologramBuilder.create("Test", player.getLocation()).block(Material.DIRT).build();
        Expectable.expect(hologram).toBeDefined();
        Expectable.expect(hologram.getData()).toBeDefined();
        Expectable.expect(hologram.getData().getName()).toBe("Test");
        Expectable.expect(hologram.getData().getLocation()).toEqual(player.getLocation());
        Expectable.expect(hologram.getData().getType()).toEqual(HologramType.BLOCK);
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof BlockHologramData)) {
            throw new AssertionError((Object)"Hologram is not a block hologram");
        }
        BlockHologramData data = (BlockHologramData)hologramData;
        Expectable.expect(data.getBlock()).toEqual(Material.DIRT);
    }

    @FPTest(name="Test hologram builder registering")
    public void testHologramBuilderRegistering(Player player) {
        String hologramName = UUID.randomUUID().toString();
        Hologram hologram = TextHologramBuilder.create(hologramName, player.getLocation()).text("Custom line").buildAndRegister();
        Expectable.expect(hologram).toBeDefined();
        Expectable.expect(hologram.getData()).toBeDefined();
        Expectable.expect(hologram.getData().getName()).toBe(hologramName);
        Expectable.expect(hologram.getData().getLocation()).toEqual(player.getLocation());
        Expectable.expect(hologram.getData().getType()).toEqual(HologramType.TEXT);
        HologramRegistry registry = FancyHologramsPlugin.get().getRegistry();
        Expectable.expect(registry.contains(hologramName)).toBe(true);
        registry.unregister(hologram);
    }
}

