/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancylib.versionFetcher;

import com.google.gson.Gson;
import de.oliver.fancylib.versionFetcher.VersionFetcher;
import java.util.Map;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class ModrinthVersionFetcher
implements VersionFetcher {
    private final String pluginName;
    private ComparableVersion newestVersion;

    public ModrinthVersionFetcher(String pluginName) {
        this.pluginName = pluginName;
        this.newestVersion = null;
    }

    @Override
    public ComparableVersion fetchNewestVersion() {
        Map[] versions;
        if (this.newestVersion != null) {
            return this.newestVersion;
        }
        String jsonString = VersionFetcher.getDataFromUrl("https://api.modrinth.com/v2/project/" + this.pluginName.toLowerCase() + "/version");
        if (jsonString == null || jsonString.isEmpty()) {
            return null;
        }
        Gson gson = new Gson();
        for (Map version : versions = gson.fromJson(jsonString, Map[].class)) {
            if (!version.get("version_type").equals("release")) continue;
            String versionNumber = (String)version.get("version_number");
            this.newestVersion = new ComparableVersion(versionNumber);
            break;
        }
        return this.newestVersion;
    }

    @Override
    public String getDownloadUrl() {
        return "https://modrinth.com/plugin/" + this.pluginName;
    }
}

